/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MailboxWatermarkProcessor<OUT> {
    protected static final Logger LOG = LoggerFactory.getLogger(MailboxWatermarkProcessor.class);
    private final Output<StreamRecord<OUT>> output;
    private final MailboxExecutor mailboxExecutor;
    private final InternalTimeServiceManager<?> internalTimeServiceManager;
    private boolean progressWatermarkScheduled = false;
    private Watermark maxInputWatermark = Watermark.UNINITIALIZED;

    public MailboxWatermarkProcessor(Output<StreamRecord<OUT>> output, MailboxExecutor mailboxExecutor, InternalTimeServiceManager<?> internalTimeServiceManager) {
        this.output = (Output)Preconditions.checkNotNull(output);
        this.mailboxExecutor = (MailboxExecutor)Preconditions.checkNotNull((Object)mailboxExecutor);
        this.internalTimeServiceManager = (InternalTimeServiceManager)Preconditions.checkNotNull(internalTimeServiceManager);
    }

    public void emitWatermarkInsideMailbox(Watermark mark) throws Exception {
        this.maxInputWatermark = new Watermark(Math.max(this.maxInputWatermark.getTimestamp(), mark.getTimestamp()));
        this.emitWatermarkInsideMailbox();
    }

    private void emitWatermarkInsideMailbox() throws Exception {
        if (this.internalTimeServiceManager.tryAdvanceWatermark(this.maxInputWatermark, () -> ((MailboxExecutor)this.mailboxExecutor).shouldInterrupt())) {
            this.output.emitWatermark(this.maxInputWatermark);
        } else if (!this.progressWatermarkScheduled) {
            this.progressWatermarkScheduled = true;
            this.mailboxExecutor.execute(MailboxExecutor.MailOptions.deferrable(), () -> {
                this.progressWatermarkScheduled = false;
                this.emitWatermarkInsideMailbox();
            }, "emitWatermarkInsideMailbox");
        } else {
            LOG.debug("emitWatermarkInsideMailbox is already scheduled, skipping.");
        }
    }
}

