/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.KeyContextHandler;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.operators.asyncprocessing.AsyncStateProcessing;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.function.ThrowingConsumer;

public class RecordProcessorUtils {
    private static final String METHOD_SET_KEY_CONTEXT_ELEMENT = "setKeyContextElement";
    private static final String METHOD_SET_KEY_CONTEXT_ELEMENT1 = "setKeyContextElement1";
    private static final String METHOD_SET_KEY_CONTEXT_ELEMENT2 = "setKeyContextElement2";

    public static <T> ThrowingConsumer<StreamRecord<T>, Exception> getRecordProcessor(Input<T> input) {
        boolean canOmitSetKeyContext;
        if (input instanceof AbstractStreamOperator) {
            canOmitSetKeyContext = RecordProcessorUtils.canOmitSetKeyContext((AbstractStreamOperator)((Object)input), 0);
        } else {
            boolean bl = canOmitSetKeyContext = input instanceof KeyContextHandler && !((KeyContextHandler)((Object)input)).hasKeyContext();
        }
        if (canOmitSetKeyContext) {
            return input::processElement;
        }
        if (input instanceof AsyncStateProcessing && ((AsyncStateProcessing)((Object)input)).isAsyncStateProcessingEnabled()) {
            return ((AsyncStateProcessing)((Object)input)).getRecordProcessor(1);
        }
        return record -> {
            input.setKeyContextElement((StreamRecord)record);
            input.processElement((StreamRecord)record);
        };
    }

    public static <T> ThrowingConsumer<StreamRecord<T>, Exception> getRecordProcessor1(TwoInputStreamOperator<T, ?, ?> operator) {
        boolean canOmitSetKeyContext;
        if (operator instanceof AbstractStreamOperator) {
            canOmitSetKeyContext = RecordProcessorUtils.canOmitSetKeyContext((AbstractStreamOperator)((Object)operator), 0);
        } else {
            boolean bl = canOmitSetKeyContext = operator instanceof KeyContextHandler && !((KeyContextHandler)((Object)operator)).hasKeyContext1();
        }
        if (canOmitSetKeyContext) {
            return operator::processElement1;
        }
        if (operator instanceof AsyncStateProcessing && ((AsyncStateProcessing)((Object)operator)).isAsyncStateProcessingEnabled()) {
            return ((AsyncStateProcessing)((Object)operator)).getRecordProcessor(1);
        }
        return record -> {
            operator.setKeyContextElement1((StreamRecord<?>)record);
            operator.processElement1((StreamRecord)record);
        };
    }

    public static <T> ThrowingConsumer<StreamRecord<T>, Exception> getRecordProcessor2(TwoInputStreamOperator<?, T, ?> operator) {
        boolean canOmitSetKeyContext;
        if (operator instanceof AbstractStreamOperator) {
            canOmitSetKeyContext = RecordProcessorUtils.canOmitSetKeyContext((AbstractStreamOperator)((Object)operator), 1);
        } else {
            boolean bl = canOmitSetKeyContext = operator instanceof KeyContextHandler && !((KeyContextHandler)((Object)operator)).hasKeyContext2();
        }
        if (canOmitSetKeyContext) {
            return operator::processElement2;
        }
        if (operator instanceof AsyncStateProcessing && ((AsyncStateProcessing)((Object)operator)).isAsyncStateProcessingEnabled()) {
            return ((AsyncStateProcessing)((Object)operator)).getRecordProcessor(2);
        }
        return record -> {
            operator.setKeyContextElement2((StreamRecord<?>)record);
            operator.processElement2((StreamRecord)record);
        };
    }

    private static boolean canOmitSetKeyContext(AbstractStreamOperator<?> streamOperator, int input) {
        return !RecordProcessorUtils.hasKeyContext(streamOperator, input) && !RecordProcessorUtils.methodSetKeyContextIsOverridden(streamOperator, input);
    }

    private static boolean hasKeyContext(AbstractStreamOperator<?> operator, int input) {
        if (input == 0) {
            return operator.hasKeyContext1();
        }
        return operator.hasKeyContext2();
    }

    private static boolean methodSetKeyContextIsOverridden(AbstractStreamOperator<?> operator, int input) {
        if (input == 0) {
            if (operator instanceof OneInputStreamOperator) {
                return RecordProcessorUtils.methodIsOverridden(operator, OneInputStreamOperator.class, METHOD_SET_KEY_CONTEXT_ELEMENT, StreamRecord.class) || RecordProcessorUtils.methodIsOverridden(operator, AbstractStreamOperator.class, METHOD_SET_KEY_CONTEXT_ELEMENT1, StreamRecord.class);
            }
            return RecordProcessorUtils.methodIsOverridden(operator, AbstractStreamOperator.class, METHOD_SET_KEY_CONTEXT_ELEMENT1, StreamRecord.class);
        }
        return RecordProcessorUtils.methodIsOverridden(operator, AbstractStreamOperator.class, METHOD_SET_KEY_CONTEXT_ELEMENT2, StreamRecord.class);
    }

    private static boolean methodIsOverridden(AbstractStreamOperator<?> operator, Class<?> expectedDeclaringClass, String methodName, Class<?> ... parameterTypes) {
        try {
            Class<?> methodDeclaringClass = operator.getClass().getMethod(methodName, parameterTypes).getDeclaringClass();
            return methodDeclaringClass != expectedDeclaringClass;
        }
        catch (NoSuchMethodException exception) {
            throw new FlinkRuntimeException(String.format("BUG: Can't find '%s' method in '%s'", methodName, operator.getClass()));
        }
    }

    private RecordProcessorUtils() {
    }
}

