/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.asyncprocessing;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.runtime.operators.asyncprocessing.AsyncStateProcessingOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.function.ThrowingConsumer;
import org.apache.flink.util.function.ThrowingRunnable;

@Internal
public interface AsyncStateProcessing {
    public boolean isAsyncStateProcessingEnabled();

    public <T> ThrowingConsumer<StreamRecord<T>, Exception> getRecordProcessor(int var1);

    public static <T> ThrowingConsumer<StreamRecord<T>, Exception> makeRecordProcessor(AsyncStateProcessingOperator asyncOperator, KeySelector<T, ?> keySelector, ThrowingConsumer<StreamRecord<T>, Exception> processor) {
        switch (asyncOperator.getElementOrder()) {
            case RECORD_ORDER: {
                return record -> {
                    asyncOperator.setAsyncKeyedContextElement(record, keySelector);
                    asyncOperator.preserveRecordOrderAndProcess((ThrowingRunnable<Exception>)((ThrowingRunnable)() -> processor.accept(record)));
                    asyncOperator.postProcessElement();
                };
            }
            case FIRST_STATE_ORDER: {
                return record -> {
                    asyncOperator.setAsyncKeyedContextElement(record, keySelector);
                    processor.accept(record);
                    asyncOperator.postProcessElement();
                };
            }
        }
        throw new UnsupportedOperationException("Unknown element order for async processing:" + (Object)((Object)asyncOperator.getElementOrder()));
    }
}

