/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.Select;

public class ExplainStatement
implements Statement {
    private Select select;
    private LinkedHashMap<OptionType, Option> options;

    public ExplainStatement() {
    }

    public ExplainStatement(Select select) {
        this.select = select;
    }

    public Select getStatement() {
        return this.select;
    }

    public void setStatement(Select select) {
        this.select = select;
    }

    public LinkedHashMap<OptionType, Option> getOptions() {
        return this.options == null ? null : new LinkedHashMap<OptionType, Option>(this.options);
    }

    public void addOption(Option option) {
        if (this.options == null) {
            this.options = new LinkedHashMap();
        }
        this.options.put(option.getType(), option);
    }

    public Option getOption(OptionType optionType) {
        if (this.options == null) {
            return null;
        }
        return this.options.get((Object)optionType);
    }

    public String toString() {
        StringBuilder statementBuilder = new StringBuilder("EXPLAIN");
        if (this.options != null) {
            statementBuilder.append(" ");
            statementBuilder.append(this.options.values().stream().map(Option::formatOption).collect(Collectors.joining(" ")));
        }
        statementBuilder.append(" ");
        statementBuilder.append(this.select.toString());
        return statementBuilder.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public static class Option
    implements Serializable {
        private final OptionType type;
        private String value;

        public Option(OptionType type) {
            this.type = type;
        }

        public OptionType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String formatOption() {
            return this.type.name() + (this.value != null ? " " + this.value : "");
        }

        public Option withValue(String value) {
            this.setValue(value);
            return this;
        }
    }

    public static enum OptionType {
        ANALYZE,
        VERBOSE,
        COSTS,
        BUFFERS,
        FORMAT;


        public static OptionType from(String type) {
            return Enum.valueOf(OptionType.class, type.toUpperCase());
        }
    }
}

