/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.executors;

import java.net.MalformedURLException;
import java.time.Duration;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.FlinkPipelineTranslationUtil;
import org.apache.flink.client.cli.ClientOptions;
import org.apache.flink.client.cli.ExecutionConfigAccessor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.PipelineOptionsInternal;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.util.Preconditions;

public class PipelineExecutorUtils {
    public static JobGraph getJobGraph(@Nonnull Pipeline pipeline, @Nonnull Configuration configuration, @Nonnull ClassLoader userClassloader) throws MalformedURLException {
        Preconditions.checkNotNull((Object)pipeline);
        Preconditions.checkNotNull((Object)configuration);
        ExecutionConfigAccessor executionConfigAccessor = ExecutionConfigAccessor.fromConfiguration(configuration);
        JobGraph jobGraph = FlinkPipelineTranslationUtil.getJobGraph(userClassloader, pipeline, configuration, executionConfigAccessor.getParallelism());
        configuration.getOptional(PipelineOptionsInternal.PIPELINE_FIXED_JOB_ID).ifPresent(strJobID -> jobGraph.setJobID(JobID.fromHexString((String)strJobID)));
        if (((Boolean)configuration.get(DeploymentOptions.ATTACHED)).booleanValue() && ((Boolean)configuration.get(DeploymentOptions.SHUTDOWN_IF_ATTACHED)).booleanValue()) {
            jobGraph.setInitialClientHeartbeatTimeout(((Duration)configuration.get(ClientOptions.CLIENT_HEARTBEAT_TIMEOUT)).toMillis());
        }
        jobGraph.addJars(executionConfigAccessor.getJars());
        jobGraph.setClasspaths(executionConfigAccessor.getClasspaths());
        jobGraph.setSavepointRestoreSettings(executionConfigAccessor.getSavepointRestoreSettings());
        return jobGraph;
    }
}

