/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CatalogImportStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CatalogImportStatus> {
    private static final SdkField<Boolean> IMPORT_COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ImportCompleted").getter(CatalogImportStatus.getter(CatalogImportStatus::importCompleted)).setter(CatalogImportStatus.setter(Builder::importCompleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportCompleted").build()}).build();
    private static final SdkField<Instant> IMPORT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ImportTime").getter(CatalogImportStatus.getter(CatalogImportStatus::importTime)).setter(CatalogImportStatus.setter(Builder::importTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTime").build()}).build();
    private static final SdkField<String> IMPORTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportedBy").getter(CatalogImportStatus.getter(CatalogImportStatus::importedBy)).setter(CatalogImportStatus.setter(Builder::importedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_COMPLETED_FIELD, IMPORT_TIME_FIELD, IMPORTED_BY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean importCompleted;
    private final Instant importTime;
    private final String importedBy;

    private CatalogImportStatus(BuilderImpl builder) {
        this.importCompleted = builder.importCompleted;
        this.importTime = builder.importTime;
        this.importedBy = builder.importedBy;
    }

    public final Boolean importCompleted() {
        return this.importCompleted;
    }

    public final Instant importTime() {
        return this.importTime;
    }

    public final String importedBy() {
        return this.importedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.importCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.importTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogImportStatus)) {
            return false;
        }
        CatalogImportStatus other = (CatalogImportStatus)obj;
        return Objects.equals(this.importCompleted(), other.importCompleted()) && Objects.equals(this.importTime(), other.importTime()) && Objects.equals(this.importedBy(), other.importedBy());
    }

    public final String toString() {
        return ToString.builder((String)"CatalogImportStatus").add("ImportCompleted", (Object)this.importCompleted()).add("ImportTime", (Object)this.importTime()).add("ImportedBy", (Object)this.importedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImportCompleted": {
                return Optional.ofNullable(clazz.cast(this.importCompleted()));
            }
            case "ImportTime": {
                return Optional.ofNullable(clazz.cast(this.importTime()));
            }
            case "ImportedBy": {
                return Optional.ofNullable(clazz.cast(this.importedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CatalogImportStatus, T> g) {
        return obj -> g.apply((CatalogImportStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean importCompleted;
        private Instant importTime;
        private String importedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogImportStatus model) {
            this.importCompleted(model.importCompleted);
            this.importTime(model.importTime);
            this.importedBy(model.importedBy);
        }

        public final Boolean getImportCompleted() {
            return this.importCompleted;
        }

        public final void setImportCompleted(Boolean importCompleted) {
            this.importCompleted = importCompleted;
        }

        @Override
        public final Builder importCompleted(Boolean importCompleted) {
            this.importCompleted = importCompleted;
            return this;
        }

        public final Instant getImportTime() {
            return this.importTime;
        }

        public final void setImportTime(Instant importTime) {
            this.importTime = importTime;
        }

        @Override
        public final Builder importTime(Instant importTime) {
            this.importTime = importTime;
            return this;
        }

        public final String getImportedBy() {
            return this.importedBy;
        }

        public final void setImportedBy(String importedBy) {
            this.importedBy = importedBy;
        }

        @Override
        public final Builder importedBy(String importedBy) {
            this.importedBy = importedBy;
            return this;
        }

        public CatalogImportStatus build() {
            return new CatalogImportStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CatalogImportStatus> {
        public Builder importCompleted(Boolean var1);

        public Builder importTime(Instant var1);

        public Builder importedBy(String var1);
    }
}

