/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.utils;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.config.Configurations;
import org.apache.amoro.server.AmoroManagementConf;

public class AmsUtil {
    private static final String ZOOKEEPER_ADDRESS_FORMAT = "zookeeper://%s/%s";
    private static final String THRIFT_ADDRESS_FORMAT = "thrift://%s:%s";

    public static Long longOrNull(String value) {
        if (value == null) {
            return null;
        }
        return Long.parseLong(value);
    }

    public static String byteToXB(long size) {
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};
        float result = size;
        float tmpResult = size;
        int unitIdx = 0;
        int unitCnt = units.length;
        while (!((result /= 1024.0f) < 1.0f) && unitIdx < unitCnt - 1) {
            tmpResult = result;
            ++unitIdx;
        }
        return String.format("%2.2f%s", Float.valueOf(tmpResult), units[unitIdx]);
    }

    public static String getFileName(String path) {
        return path == null ? null : new File(path).getName();
    }

    public static Map<String, String> getNotDeprecatedAndNotInternalStaticFields(Class<?> clazz) throws IllegalAccessException {
        List fields = Arrays.stream(clazz.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> f.getAnnotation(Deprecated.class) == null).collect(Collectors.toList());
        HashMap<String, String> result = new HashMap<String, String>();
        for (Field field : fields) {
            result.put(field.getName(), field.get(null) + "");
        }
        return result;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(sw);){
            throwable.printStackTrace(printWriter);
            String string = sw.toString();
            return string;
        }
    }

    public static InetAddress lookForBindHost(String prefix) {
        if (prefix.startsWith("0")) {
            throw new RuntimeException("config " + AmoroManagementConf.SERVER_EXPOSE_HOST.key() + " can't start with 0");
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    InetAddress inetAddress = enumeration.nextElement();
                    if (!AmsUtil.checkHostAddress(inetAddress, prefix)) continue;
                    return inetAddress;
                }
            }
            throw new IllegalArgumentException("Can't find host address start with " + prefix);
        }
        catch (Exception e) {
            throw new RuntimeException("Look for bind host failed", e);
        }
    }

    public static String getAMSThriftAddress(Configurations conf, String serviceName) {
        if (conf.getBoolean(AmoroManagementConf.HA_ENABLE)) {
            return String.format(ZOOKEEPER_ADDRESS_FORMAT, conf.getString(AmoroManagementConf.HA_ZOOKEEPER_ADDRESS), conf.getString(AmoroManagementConf.HA_CLUSTER_NAME));
        }
        if ("TableMetastore".equals(serviceName)) {
            return String.format(THRIFT_ADDRESS_FORMAT, conf.getString(AmoroManagementConf.SERVER_EXPOSE_HOST), conf.getInteger(AmoroManagementConf.TABLE_SERVICE_THRIFT_BIND_PORT));
        }
        if ("OptimizeManager".equals(serviceName)) {
            return String.format(THRIFT_ADDRESS_FORMAT, conf.getString(AmoroManagementConf.SERVER_EXPOSE_HOST), conf.getInteger(AmoroManagementConf.OPTIMIZING_SERVICE_THRIFT_BIND_PORT));
        }
        throw new IllegalArgumentException(String.format("Unknown service name %s", serviceName));
    }

    public static String formatString(String beforeFormat) {
        StringBuilder result = new StringBuilder();
        int flag = 0;
        for (int i = 0; i < beforeFormat.length(); ++i) {
            String s = String.valueOf(beforeFormat.toCharArray()[i]);
            if (!s.matches("[a-zA-Z]+")) {
                flag = 0;
                result.append(" ");
                continue;
            }
            result.append(flag == 0 ? s.toUpperCase() : s.toLowerCase());
            ++flag;
        }
        return result.toString();
    }

    private static boolean checkHostAddress(InetAddress address, String prefix) {
        return address != null && address.getHostAddress().startsWith(prefix);
    }
}

