/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.utils;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;

public class PropertiesUtil {
    public static void putNotNullProperties(Map<String, String> properties, String key, String value) {
        if (value != null) {
            properties.put(key, value);
        }
    }

    public static void removeHiddenProperties(Map<String, String> properties, Set<String> skipKeys) {
        for (String skipKey : skipKeys) {
            properties.remove(skipKey);
        }
    }

    public static Map<String, String> extractTableProperties(Map<String, String> catalogProperties) {
        HashMap result = Maps.newHashMap();
        catalogProperties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("table.")).forEach(entry -> {
            String cfr_ignored_0 = (String)result.put(((String)entry.getKey()).replaceFirst("table.", ""), entry.getValue());
        });
        return result;
    }

    public static Map<String, String> extractCatalogMetaProperties(Map<String, String> catalogProperties) {
        HashMap result = Maps.newHashMap();
        catalogProperties.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("table.")).forEach(entry -> {
            String cfr_ignored_0 = (String)result.put(entry.getKey(), entry.getValue());
        });
        return result;
    }

    public static Map<String, String> unionCatalogProperties(Map<String, String> tableProperties, Map<String, String> catalogMetaProperties) {
        HashMap result = Maps.newHashMap(catalogMetaProperties);
        tableProperties.forEach((key, value) -> result.put("table." + key, value));
        return result;
    }

    public static Map<String, String> sanitizeProperties(Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return Collections.emptyMap();
        }
        return properties.entrySet().stream().map(entry -> {
            String key = entry.getKey() == null ? "" : ((String)entry.getKey()).trim();
            String value = entry.getValue() == null ? null : ((String)entry.getValue()).trim();
            return new AbstractMap.SimpleEntry<String, String>(key, value);
        }).filter(e -> !((String)e.getKey()).isEmpty() && e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2));
    }
}

