/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.executor;

import org.apache.amoro.AmoroTable;
import org.apache.amoro.config.TableConfiguration;
import org.apache.amoro.server.optimizing.maintainer.TableMaintainer;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.server.table.executor.BaseTableExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DanglingDeleteFilesCleaningExecutor
extends BaseTableExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(DanglingDeleteFilesCleaningExecutor.class);
    private static final long INTERVAL = 86400000L;

    protected DanglingDeleteFilesCleaningExecutor(TableService tableService, int poolSize) {
        super(tableService, poolSize);
    }

    @Override
    protected long getNextExecutingTime(TableRuntime tableRuntime) {
        return 86400000L;
    }

    @Override
    protected boolean enabled(TableRuntime tableRuntime) {
        return tableRuntime.getTableConfiguration().isDeleteDanglingDeleteFilesEnabled();
    }

    @Override
    public void handleConfigChanged(TableRuntime tableRuntime, TableConfiguration originalConfig) {
        this.scheduleIfNecessary(tableRuntime, this.getStartDelay());
    }

    @Override
    protected void execute(TableRuntime tableRuntime) {
        try {
            LOG.info("{} start cleaning dangling delete files", (Object)tableRuntime.getTableIdentifier());
            AmoroTable<?> amoroTable = this.loadTable(tableRuntime);
            TableMaintainer tableMaintainer = TableMaintainer.ofTable(amoroTable);
            tableMaintainer.cleanDanglingDeleteFiles(tableRuntime);
        }
        catch (Throwable t) {
            LOG.error("{} failed to clean dangling delete file", (Object)tableRuntime.getTableIdentifier(), (Object)t);
        }
    }
}

