/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.fluss.flink.tiering.committer;

import org.apache.fluss.config.Configuration;
import org.apache.fluss.flink.tiering.source.TableBucketWriteResult;
import org.apache.fluss.lake.writer.LakeTieringFactory;

import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;

/** The factory to create {@link TieringCommitOperator}. */
public class TieringCommitOperatorFactory<WriteResult, Committable>
        extends AbstractStreamOperatorFactory<CommittableMessage<Committable>>
        implements OneInputStreamOperatorFactory<
                TableBucketWriteResult<WriteResult>, CommittableMessage<Committable>> {

    private final Configuration flussConfig;
    private final LakeTieringFactory<WriteResult, Committable> lakeTieringFactory;

    public TieringCommitOperatorFactory(
            Configuration flussConfig,
            LakeTieringFactory<WriteResult, Committable> lakeTieringFactory) {
        this.flussConfig = flussConfig;
        this.lakeTieringFactory = lakeTieringFactory;
    }

    @Override
    public <T extends StreamOperator<CommittableMessage<Committable>>> T createStreamOperator(
            StreamOperatorParameters<CommittableMessage<Committable>> parameters) {

        TieringCommitOperator<WriteResult, Committable> commitOperator =
                new TieringCommitOperator<>(parameters, flussConfig, lakeTieringFactory);

        @SuppressWarnings("unchecked")
        final T castedOperator = (T) commitOperator;

        return castedOperator;
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return TieringCommitOperator.class;
    }
}
