/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


import { describe, it } from 'node:test';
import assert from 'node:assert/strict';
import { LOGIN_WITH_TOKEN } from './login-with-token.command.js';


describe("Login with token Command", () => {

  // @warn use ascii char to keep char.length === byteLength
  const t1 = { token: 'thisIsBigSecretToken123' };

  it("serialize token into a buffer", () => {
    assert.deepEqual(
      LOGIN_WITH_TOKEN.serialize(t1).length,
      1 + t1.token.length
    );
  });

  it("throw on empty token", () => {
    assert.throws(
      () => LOGIN_WITH_TOKEN.serialize({token: ""})
    );
  });

  it("throw on token > 255 bytes", () => {
    assert.throws(
      () => LOGIN_WITH_TOKEN.serialize({token: "YoLo".repeat(65)})
    );
  });

  it("throw on login > 255 bytes - utf8 version", () => {
    assert.throws(
      () => LOGIN_WITH_TOKEN.serialize({token: "¥Ø£Ø".repeat(33)})
    );
  });

});
