/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.v1.handler;

import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.protocol.rest.v1.model.ExpressionRequest;
import org.apache.iotdb.db.protocol.rest.v1.model.InsertTabletRequest;
import org.apache.iotdb.db.protocol.rest.v1.model.SQL;

public class RequestValidationHandler {
    private RequestValidationHandler() {
    }

    public static void validateSQL(SQL sql) {
        Objects.requireNonNull(sql.getSql(), "sql should not be null");
        if (sql.getRowLimit() != null) {
            Validate.isTrue((sql.getRowLimit() > 0 ? 1 : 0) != 0, (String)"rowLimit should be positive", (Object[])new Object[0]);
        }
    }

    public static void validateInsertTabletRequest(InsertTabletRequest insertTabletRequest) {
        Objects.requireNonNull(insertTabletRequest.getTimestamps(), "timestamps should not be null");
        Objects.requireNonNull(insertTabletRequest.getIsAligned(), "isAligned should not be null");
        Objects.requireNonNull(insertTabletRequest.getDeviceId(), "deviceId should not be null");
        Objects.requireNonNull(insertTabletRequest.getDataTypes(), "dataTypes should not be null");
        Objects.requireNonNull(insertTabletRequest.getValues(), "values should not be null");
    }

    public static void validateExpressionRequest(ExpressionRequest expressionRequest) {
        Objects.requireNonNull(expressionRequest.getExpression(), "expression should not be null");
        Objects.requireNonNull(expressionRequest.getPrefixPath(), "prefixPath should not be null");
        Objects.requireNonNull(expressionRequest.getStartTime(), "startTime should not be null");
        Objects.requireNonNull(expressionRequest.getEndTime(), "endTime should not be null");
    }
}

