/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.queryengine.common.DeviceContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractRegionScanForActiveDataUtil;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.AbstractChunkOffset;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.AbstractDeviceChunkMetaData;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.DeviceStartEndTime;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileDeviceStartEndTimeIterator;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.RamUsageEstimator;

public class RegionScanForActiveDeviceUtil
extends AbstractRegionScanForActiveDataUtil {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(RegionScanForActiveDeviceUtil.class) + RamUsageEstimator.shallowSizeOfInstance(Set.class) + RamUsageEstimator.shallowSizeOfInstance(List.class);
    private final Set<IDeviceID> deviceSetForCurrentTsFile = new HashSet<IDeviceID>();
    private final List<IDeviceID> activeDevices = new ArrayList<IDeviceID>();

    public RegionScanForActiveDeviceUtil(Filter timeFilter, Map<IDeviceID, Long> ttlCache) {
        super(timeFilter, ttlCache);
    }

    @Override
    public boolean isCurrentTsFileFinished() {
        return this.deviceSetForCurrentTsFile.isEmpty();
    }

    public boolean nextTsFileHandle(Map<IDeviceID, DeviceContext> targetDevices) throws IOException, IllegalPathException {
        if (!this.queryDataSource.hasNext()) {
            return false;
        }
        this.curFileScanHandle = this.queryDataSource.next();
        this.deviceChunkMetaDataIterator = null;
        TsFileDeviceStartEndTimeIterator iterator = this.curFileScanHandle.getDeviceStartEndTimeIterator();
        while (iterator.hasNext()) {
            DeviceStartEndTime deviceStartEndTime = iterator.next();
            IDeviceID deviceID = deviceStartEndTime.getDevicePath();
            long startTime = deviceStartEndTime.getStartTime();
            long endTime = deviceStartEndTime.getEndTime();
            if (!targetDevices.containsKey(deviceID) || endTime >= 0L && !this.timeFilter.satisfyStartEndTime(startTime, endTime, deviceID)) continue;
            if (this.timeFilter.satisfy(startTime, deviceID) && !this.curFileScanHandle.isDeviceTimeDeleted(deviceID, startTime) || endTime >= 0L && this.timeFilter.satisfy(endTime, deviceID) && !this.curFileScanHandle.isDeviceTimeDeleted(deviceID, endTime)) {
                this.activeDevices.add(deviceID);
                continue;
            }
            this.deviceSetForCurrentTsFile.add(deviceID);
        }
        return true;
    }

    @Override
    public void processDeviceChunkMetadata(AbstractDeviceChunkMetaData deviceChunkMetaData) throws IllegalPathException {
        IDeviceID curDevice = deviceChunkMetaData.getDevicePath();
        if (this.deviceSetForCurrentTsFile.contains(curDevice) && this.checkChunkMetaDataOfDevice(curDevice, deviceChunkMetaData)) {
            this.deviceSetForCurrentTsFile.remove(curDevice);
            this.activeDevices.add(curDevice);
        }
    }

    @Override
    public boolean isCurrentChunkHandleValid() {
        return this.deviceSetForCurrentTsFile.contains(this.currentChunkHandle.getDeviceID());
    }

    @Override
    public void processActiveChunk(IDeviceID deviceID, String measurementId) {
        this.deviceSetForCurrentTsFile.remove(deviceID);
        this.activeDevices.add(deviceID);
        this.timeFilter.removeTTLCache(deviceID);
        this.currentChunkHandle = null;
    }

    private boolean checkChunkMetaDataOfDevice(IDeviceID deviceID, AbstractDeviceChunkMetaData deviceChunkMetaData) throws IllegalPathException {
        ArrayList<AbstractChunkOffset> chunkOffsetsForCurrentDevice = new ArrayList<AbstractChunkOffset>();
        ArrayList<Statistics> chunkStatisticsForCurrentDevice = new ArrayList<Statistics>();
        while (deviceChunkMetaData.hasNextValueChunkMetadata()) {
            long endTime;
            IChunkMetadata valueChunkMetaData = deviceChunkMetaData.nextValueChunkMetadata();
            long startTime = valueChunkMetaData.getStartTime();
            if (!this.timeFilter.satisfyStartEndTime(startTime, endTime = valueChunkMetaData.getEndTime(), deviceID)) continue;
            String measurement = valueChunkMetaData.getMeasurementUid();
            if (this.timeFilter.satisfy(startTime, deviceID) && !this.curFileScanHandle.isTimeSeriesTimeDeleted(deviceID, measurement, startTime) || this.timeFilter.satisfy(endTime, deviceID) && !this.curFileScanHandle.isTimeSeriesTimeDeleted(deviceID, measurement, endTime)) {
                return true;
            }
            chunkOffsetsForCurrentDevice.add(deviceChunkMetaData.getChunkOffset());
            chunkStatisticsForCurrentDevice.add(valueChunkMetaData.getStatistics());
        }
        this.chunkToBeScanned.addAll(chunkOffsetsForCurrentDevice);
        this.chunkStatistics.addAll(chunkStatisticsForCurrentDevice);
        return false;
    }

    public List<IDeviceID> getActiveDevices() {
        return this.activeDevices;
    }

    @Override
    public void finishCurrentFile() {
        super.finishCurrentFile();
        this.queryDataSource.releaseFileScanHandle();
        this.deviceSetForCurrentTsFile.clear();
        this.activeDevices.clear();
    }

    @Override
    public long ramBytesUsed() {
        return INSTANCE_SIZE + super.ramBytesUsed();
    }
}

