/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.metric;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.schemaengine.metric.ISchemaEngineMetric;
import org.apache.iotdb.db.schemaengine.metric.SchemaEngineMemMetric;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.ReleaseFlushMonitor;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class SchemaEngineCachedMetric
implements ISchemaEngineMetric {
    private static final String RELEASE_THRESHOLD = "pbtree_release_threshold";
    private static final String PINNED_NODE_NUM = "pbtree_pinned_num";
    private static final String UNPINNED_NODE_NUM = "pbtree_unpinned_num";
    private static final String PINNED_MEM_SIZE = "pbtree_pinned_mem";
    private static final String UNPINNED_MEM_SIZE = "pbtree_unpinned_mem";
    private static final String RELEASE_FLUSH_THREAD_NUM = "pbtree_release_flush_thread_num";
    private final CachedSchemaEngineStatistics engineStatistics;
    private final SchemaEngineMemMetric schemaEngineMemMetric;

    public SchemaEngineCachedMetric(CachedSchemaEngineStatistics engineStatistics) {
        this.engineStatistics = engineStatistics;
        this.schemaEngineMemMetric = new SchemaEngineMemMetric(engineStatistics);
    }

    public void bindTo(AbstractMetricService metricService) {
        this.schemaEngineMemMetric.bindTo(metricService);
        metricService.gauge((long)((double)IoTDBDescriptor.getInstance().getConfig().getAllocateMemoryForSchemaRegion() * 0.7), Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RELEASE_THRESHOLD});
        metricService.createAutoGauge(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, (Object)this.engineStatistics, CachedSchemaEngineStatistics::getPinnedMNodeNum, new String[]{Tag.NAME.toString(), PINNED_NODE_NUM});
        metricService.createAutoGauge(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, (Object)this.engineStatistics, CachedSchemaEngineStatistics::getUnpinnedMNodeNum, new String[]{Tag.NAME.toString(), UNPINNED_NODE_NUM});
        metricService.createAutoGauge(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, (Object)this.engineStatistics, CachedSchemaEngineStatistics::getPinnedMemorySize, new String[]{Tag.NAME.toString(), PINNED_MEM_SIZE});
        metricService.createAutoGauge(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, (Object)this.engineStatistics, CachedSchemaEngineStatistics::getUnpinnedMemorySize, new String[]{Tag.NAME.toString(), UNPINNED_MEM_SIZE});
        metricService.createAutoGauge(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, (Object)ReleaseFlushMonitor.getInstance(), ReleaseFlushMonitor::getActiveWorkerNum, new String[]{Tag.NAME.toString(), RELEASE_FLUSH_THREAD_NUM});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.schemaEngineMemMetric.unbindFrom(metricService);
        metricService.remove(MetricType.GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), RELEASE_THRESHOLD});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), PINNED_NODE_NUM});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), UNPINNED_NODE_NUM});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), PINNED_MEM_SIZE});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), UNPINNED_MEM_SIZE});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), RELEASE_FLUSH_THREAD_NUM});
    }
}

