/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.partition.Partition;
import org.apache.iotdb.commons.partition.RegionReplicaSetInfo;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.rpc.TSStatusCode;

public class SchemaPartition
extends Partition {
    private Map<String, Map<TSeriesPartitionSlot, TRegionReplicaSet>> schemaPartitionMap;

    public SchemaPartition(String seriesSlotExecutorName, int seriesPartitionSlotNum) {
        super(seriesSlotExecutorName, seriesPartitionSlotNum);
    }

    @Override
    public boolean isEmpty() {
        return this.schemaPartitionMap == null || this.schemaPartitionMap.isEmpty();
    }

    public SchemaPartition(Map<String, Map<TSeriesPartitionSlot, TRegionReplicaSet>> schemaPartitionMap, String seriesSlotExecutorName, int seriesPartitionSlotNum) {
        this(seriesSlotExecutorName, seriesPartitionSlotNum);
        this.schemaPartitionMap = schemaPartitionMap;
    }

    public Map<String, Map<TSeriesPartitionSlot, TRegionReplicaSet>> getSchemaPartitionMap() {
        return this.schemaPartitionMap;
    }

    public void setSchemaPartitionMap(Map<String, Map<TSeriesPartitionSlot, TRegionReplicaSet>> schemaPartitionMap) {
        this.schemaPartitionMap = schemaPartitionMap;
    }

    public TRegionReplicaSet getSchemaRegionReplicaSet(String deviceName) {
        String storageGroup = this.getStorageGroupByDevice(deviceName);
        TSeriesPartitionSlot seriesPartitionSlot = this.calculateDeviceGroupId(deviceName);
        if (this.schemaPartitionMap.get(storageGroup) == null) {
            throw new RuntimeException(new IoTDBException("Path does not exist. ", TSStatusCode.PATH_NOT_EXIST.getStatusCode()));
        }
        return this.schemaPartitionMap.get(storageGroup).get(seriesPartitionSlot);
    }

    private String getStorageGroupByDevice(String deviceName) {
        for (String storageGroup : this.schemaPartitionMap.keySet()) {
            if (!PathUtils.isStartWith(deviceName, storageGroup)) continue;
            return storageGroup;
        }
        return null;
    }

    @Override
    public List<RegionReplicaSetInfo> getDistributionInfo() {
        HashMap distributionMap = new HashMap();
        this.schemaPartitionMap.forEach((storageGroup, partition) -> {
            for (TRegionReplicaSet regionReplicaSet : partition.values()) {
                distributionMap.computeIfAbsent(regionReplicaSet, RegionReplicaSetInfo::new).setStorageGroup((String)storageGroup);
            }
        });
        return new ArrayList<RegionReplicaSetInfo>(distributionMap.values());
    }
}

