/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator;

import java.time.ZoneId;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.AggrWindowIterator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.PreAggrWindowIterator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.PreAggrWindowWithNaturalMonthIterator;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.tsfile.utils.TimeDuration;

public class TimeRangeIteratorFactory {
    private TimeRangeIteratorFactory() {
    }

    public static ITimeRangeIterator getTimeRangeIterator(long startTime, long endTime, TimeDuration interval, TimeDuration slidingStep, boolean isAscending, boolean leftCRightO, boolean outputPartialTimeWindow, ZoneId zoneId) {
        if (outputPartialTimeWindow && interval.getTotalDuration(TimestampPrecisionUtils.currPrecision) > slidingStep.getTotalDuration(TimestampPrecisionUtils.currPrecision)) {
            if (!interval.containsMonth() && !slidingStep.containsMonth()) {
                return new PreAggrWindowIterator(startTime, endTime, interval.nonMonthDuration, slidingStep.nonMonthDuration, isAscending, leftCRightO);
            }
            return new PreAggrWindowWithNaturalMonthIterator(startTime, endTime, interval, slidingStep, isAscending, leftCRightO, zoneId);
        }
        return new AggrWindowIterator(startTime, endTime, interval, slidingStep, isAscending, leftCRightO, zoneId);
    }
}

