/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadUtils {
    public static ThreadFactory createThreadFactory(final String threadNamePrefix, final boolean isDaemon) {
        return new ThreadFactory(){
            private final AtomicInteger threadCount = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(String.format("%s-%d", threadNamePrefix, this.threadCount.getAndIncrement()));
                thread.setDaemon(isDaemon);
                return thread;
            }
        };
    }

    private ThreadUtils() {
    }
}

