/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.UserManagerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityManagerConfig
extends BeanConfig {
    private static final Logger log = LoggerFactory.getLogger(SecurityManagerConfig.class);
    private final String workspaceName;
    private final BeanConfig workspaceAccessConfig;
    private final UserManagerConfig userManagerConfig;
    private final Class uidClass;

    public SecurityManagerConfig(BeanConfig config, String workspaceName, BeanConfig workspaceAccessConfig) {
        this(config, workspaceName, workspaceAccessConfig, null, null);
    }

    public SecurityManagerConfig(BeanConfig config, String workspaceName, BeanConfig workspaceAccessConfig, UserManagerConfig userManagerConfig, BeanConfig uidClassConfig) {
        super(config);
        this.workspaceName = workspaceName;
        this.workspaceAccessConfig = workspaceAccessConfig;
        this.userManagerConfig = userManagerConfig;
        Class<?> cl = null;
        if (uidClassConfig != null) {
            try {
                cl = Class.forName(uidClassConfig.getClassName(), true, uidClassConfig.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                log.error("Configured bean implementation class " + uidClassConfig.getClassName() + " was not found -> Ignoring UserIdClass element.", e);
            }
        }
        this.uidClass = cl;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public BeanConfig getWorkspaceAccessConfig() {
        return this.workspaceAccessConfig;
    }

    public UserManagerConfig getUserManagerConfig() {
        return this.userManagerConfig;
    }

    public Class getUserIdClass() {
        return this.uidClass;
    }
}

