/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.info;

import java.util.Iterator;
import java.util.ResourceBundle;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public abstract class AbstractLs
implements Command {
    private static ResourceBundle bundle = CommandHelper.getBundle();
    protected int longWidth = 9;
    private int defaultMaxItems = 100;
    private String maxItemsKey = "maxItems";
    private boolean path;

    protected void printFooter(Context ctx, Iterator iter) {
        CommandHelper.getOutput(ctx).println();
        CommandHelper.getOutput(ctx).println(bundle.getString("word.total"));
        if (iter instanceof NodeIterator) {
            this.printFooter(ctx, (NodeIterator)iter);
        } else if (iter instanceof PropertyIterator) {
            this.printFooter(ctx, (PropertyIterator)iter);
        }
    }

    private void printFooter(Context ctx, NodeIterator iter) {
        CommandHelper.getOutput(ctx).println(iter.getSize() + " " + bundle.getString("word.nodes"));
    }

    private void printFooter(Context ctx, PropertyIterator iter) {
        CommandHelper.getOutput(ctx).println(iter.getSize() + " " + bundle.getString("word.properties"));
    }

    public int getDefaultMaxItems() {
        return this.defaultMaxItems;
    }

    public void setDefaultMaxItems(int maxItems) {
        this.defaultMaxItems = maxItems;
    }

    public boolean isPath() {
        return this.path;
    }

    public void setPath(boolean path) {
        this.path = path;
    }

    public String getMaxItemsKey() {
        return this.maxItemsKey;
    }

    public void setMaxItemsKey(String maxItemsKey) {
        this.maxItemsKey = maxItemsKey;
    }

    protected int getMaxItems(Context ctx) {
        String maxItems = (String)ctx.get(this.maxItemsKey);
        if (maxItems == null) {
            maxItems = new Integer(this.defaultMaxItems).toString();
        }
        return Integer.valueOf(maxItems);
    }
}

