/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import org.apache.tika.exception.TikaException;
import org.apache.tika.utils.StringUtils;

class FileNodeListHeader {
    public static final long UNIT_MAGIC_CONSTANT = -6604956898737785660L;
    long position;
    long fileNodeListId;
    long nFragmentSequence;

    public FileNodeListHeader(long position, long uintMagic, long fileNodeListId, long nFragmentSequence) throws TikaException {
        if (uintMagic != -6604956898737785660L) {
            throw new TikaException("unitMagic must always be: 0x" + Long.toHexString(-6604956898737785660L));
        }
        this.position = position;
        this.fileNodeListId = fileNodeListId;
        if (fileNodeListId < 16L) {
            throw new TikaException("FileNodeListHeader.fileNodeListId MUST be equal to or greater than 0x00000010");
        }
        this.nFragmentSequence = nFragmentSequence;
    }

    public long getFileNodeListId() {
        return this.fileNodeListId;
    }

    public FileNodeListHeader setFileNodeListId(long fileNodeListId) {
        this.fileNodeListId = fileNodeListId;
        return this;
    }

    public long getnFragmentSequence() {
        return this.nFragmentSequence;
    }

    public FileNodeListHeader setnFragmentSequence(long nFragmentSequence) {
        this.nFragmentSequence = nFragmentSequence;
        return this;
    }

    public long getPosition() {
        return this.position;
    }

    public FileNodeListHeader setPosition(long position) {
        this.position = position;
        return this;
    }

    public String getPositionHex() {
        return "0x" + StringUtils.leftPad(Long.toHexString(this.position), 8, '0');
    }

    public String toString() {
        return "FileNodeListHeader{position=0x" + StringUtils.leftPad(Long.toHexString(this.position), 8, '0') + ", fileNodeListId=" + this.fileNodeListId + ", nFragmentSequence=" + this.nFragmentSequence + '}';
    }
}

