/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.policies.local;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.james.jspf.core.SPF1Record;
import org.apache.james.jspf.core.SPFRecordParser;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.SPFResultException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.policies.PolicyPostFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackPolicy
implements PolicyPostFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FallbackPolicy.class);
    private Map<String, SPF1Record> entryMap = Collections.synchronizedMap(new HashMap());
    private SPFRecordParser parser;

    public FallbackPolicy(SPFRecordParser parser) {
        this.parser = parser;
    }

    public void addEntry(String rawHost, String rawSpfRecord) throws IllegalArgumentException {
        try {
            String host;
            LOGGER.debug("Start parsing SPF-Record: {}", (Object)rawSpfRecord);
            SPF1Record spfRecord = this.parser.parse(rawSpfRecord);
            if (rawHost.startsWith("*")) {
                host = rawHost.substring(1);
                LOGGER.debug("Convert host {} to {}", (Object)rawHost, (Object)host);
            } else if (rawHost.endsWith("*")) {
                int length = rawHost.length();
                host = rawHost.substring(length - 1, length);
                LOGGER.debug("Convert host {} to {}", (Object)rawHost, (Object)host);
            } else {
                host = rawHost;
            }
            this.entryMap.put(host, spfRecord);
        }
        catch (SPFResultException e) {
            throw new IllegalArgumentException("Invalid SPF-Record: " + rawSpfRecord);
        }
    }

    public void clearEntrys() {
        LOGGER.debug("Clear all entries");
        this.entryMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(String host) {
        LOGGER.debug("Remove fallback entry for host: {}", (Object)host);
        Map<String, SPF1Record> map = this.entryMap;
        synchronized (map) {
            this.entryMap.remove(this.getRawEntry(host));
        }
    }

    @Override
    public SPF1Record getSPFRecord(String currentDomain, SPF1Record res) throws PermErrorException, TempErrorException, NoneException, NeutralException {
        if (res == null) {
            return this.getMySPFRecord(currentDomain);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SPF1Record getMySPFRecord(String host) {
        SPF1Record entry = null;
        Map<String, SPF1Record> map = this.entryMap;
        synchronized (map) {
            entry = this.getRawEntry(host);
        }
        if (entry != null) {
            return entry;
        }
        return null;
    }

    private SPF1Record getRawEntry(String host) {
        for (String rawHost : this.entryMap.keySet()) {
            if ((!rawHost.startsWith(".") || !host.startsWith(rawHost)) && (!rawHost.endsWith(".") || !host.endsWith(rawHost))) continue;
            return this.entryMap.get(rawHost);
        }
        return null;
    }
}

