/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MaxScoreAccumulator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TotalHits;

public class TopScoreDocCollector
extends TopDocsCollector<ScoreDoc> {
    private final ScoreDoc after;
    final int totalHitsThreshold;
    final MaxScoreAccumulator minScoreAcc;

    TopScoreDocCollector(int numHits, ScoreDoc after, int totalHitsThreshold, MaxScoreAccumulator minScoreAcc) {
        super(new HitQueue(numHits, true));
        this.after = after;
        this.totalHitsThreshold = totalHitsThreshold;
        this.minScoreAcc = minScoreAcc;
    }

    @Override
    protected int topDocsSize() {
        int[] validTopHitCount = new int[1];
        this.pq.forEach(scoreDoc -> {
            if (scoreDoc.doc != Integer.MAX_VALUE) {
                validTopHitCount[0] = validTopHitCount[0] + 1;
            }
        });
        return validTopHitCount[0];
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        return results == null ? new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), new ScoreDoc[0]) : new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), results);
    }

    @Override
    public ScoreMode scoreMode() {
        return this.totalHitsThreshold == Integer.MAX_VALUE ? ScoreMode.COMPLETE : ScoreMode.TOP_SCORES;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        int afterDoc;
        float afterScore;
        final int docBase = context.docBase;
        final ScoreDoc after = this.after;
        if (after == null) {
            afterScore = Float.POSITIVE_INFINITY;
            afterDoc = Integer.MAX_VALUE;
        } else {
            afterScore = after.score;
            afterDoc = after.doc - context.docBase;
        }
        return new LeafCollector(){
            private Scorable scorer;
            private ScoreDoc pqTop;
            private float minCompetitiveScore;
            {
                this.pqTop = (ScoreDoc)TopScoreDocCollector.this.pq.top();
            }

            @Override
            public void setScorer(Scorable scorer) throws IOException {
                this.scorer = scorer;
                if (TopScoreDocCollector.this.minScoreAcc == null) {
                    this.updateMinCompetitiveScore(scorer);
                } else {
                    this.updateGlobalMinCompetitiveScore(scorer);
                }
            }

            @Override
            public void collect(int doc) throws IOException {
                float score = this.scorer.score();
                int hitCountSoFar = ++TopScoreDocCollector.this.totalHits;
                if (TopScoreDocCollector.this.minScoreAcc != null && ((long)hitCountSoFar & TopScoreDocCollector.this.minScoreAcc.modInterval) == 0L) {
                    this.updateGlobalMinCompetitiveScore(this.scorer);
                }
                if (after != null && (score > afterScore || score == afterScore && doc <= afterDoc)) {
                    if (TopScoreDocCollector.this.totalHitsRelation == TotalHits.Relation.EQUAL_TO) {
                        this.updateMinCompetitiveScore(this.scorer);
                    }
                    return;
                }
                if (score <= this.pqTop.score) {
                    if (hitCountSoFar == TopScoreDocCollector.this.totalHitsThreshold + 1) {
                        this.updateMinCompetitiveScore(this.scorer);
                    }
                } else {
                    this.collectCompetitiveHit(doc, score);
                }
            }

            private void collectCompetitiveHit(int doc, float score) throws IOException {
                this.pqTop.doc = doc + docBase;
                this.pqTop.score = score;
                this.pqTop = (ScoreDoc)TopScoreDocCollector.this.pq.updateTop();
                this.updateMinCompetitiveScore(this.scorer);
            }

            private void updateGlobalMinCompetitiveScore(Scorable scorer) throws IOException {
                assert (TopScoreDocCollector.this.minScoreAcc != null);
                long maxMinScore = TopScoreDocCollector.this.minScoreAcc.getRaw();
                if (maxMinScore != Long.MIN_VALUE) {
                    float score = MaxScoreAccumulator.toScore(maxMinScore);
                    float f = score = docBase >= MaxScoreAccumulator.docId(maxMinScore) ? Math.nextUp(score) : score;
                    if (score > this.minCompetitiveScore) {
                        scorer.setMinCompetitiveScore(score);
                        this.minCompetitiveScore = score;
                        TopScoreDocCollector.this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                    }
                }
            }

            private void updateMinCompetitiveScore(Scorable scorer) throws IOException {
                float localMinScore;
                if (TopScoreDocCollector.this.totalHits > TopScoreDocCollector.this.totalHitsThreshold && (localMinScore = Math.nextUp(this.pqTop.score)) > this.minCompetitiveScore) {
                    scorer.setMinCompetitiveScore(localMinScore);
                    TopScoreDocCollector.this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                    this.minCompetitiveScore = localMinScore;
                    if (TopScoreDocCollector.this.minScoreAcc != null) {
                        TopScoreDocCollector.this.minScoreAcc.accumulate(this.pqTop.doc, this.pqTop.score);
                    }
                }
            }
        };
    }
}

