/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.postgres;

import java.time.OffsetDateTime;
import java.util.UUID;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresSieveDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{PostgresSieveScriptTable.TABLE}).addIndex(new PostgresIndex[]{PostgresSieveScriptTable.MAXIMUM_ONE_ACTIVE_SCRIPT_PER_USER_UNIQUE_INDEX}).build();

    public static interface PostgresSieveScriptTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"sieve_scripts");
        public static final Field<String> USERNAME = DSL.field((String)"username", (DataType)SQLDataType.VARCHAR((int)255).notNull());
        public static final Field<String> SCRIPT_NAME = DSL.field((String)"script_name", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<UUID> SCRIPT_ID = DSL.field((String)"script_id", (DataType)SQLDataType.UUID.notNull());
        public static final Field<Long> SCRIPT_SIZE = DSL.field((String)"script_size", (DataType)SQLDataType.BIGINT.notNull());
        public static final Field<String> SCRIPT_CONTENT = DSL.field((String)"script_content", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<Boolean> IS_ACTIVE = DSL.field((String)"is_active", (DataType)SQLDataType.BOOLEAN.notNull());
        public static final Field<OffsetDateTime> ACTIVATION_DATE_TIME = DSL.field((String)"activation_date_time", (DataType)SQLDataType.OFFSETDATETIME);
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(SCRIPT_ID).column(USERNAME).column(SCRIPT_NAME).column(SCRIPT_SIZE).column(SCRIPT_CONTENT).column(IS_ACTIVE).column(ACTIVATION_DATE_TIME).primaryKey(new Field[]{SCRIPT_ID}).constraint((Constraint)DSL.unique((Field[])new Field[]{USERNAME, SCRIPT_NAME}))).disableRowLevelSecurity().build();
        public static final PostgresIndex MAXIMUM_ONE_ACTIVE_SCRIPT_PER_USER_UNIQUE_INDEX = PostgresIndex.name((String)"maximum_one_active_script_per_user").createIndexStep((dsl, indexName) -> dsl.createUniqueIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{USERNAME}).where(IS_ACTIVE));
    }
}

