/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.util.MDCBuilder;

public interface ProtocolMDCContextFactory {
    public static final boolean ADD_HOST_TO_MDC = Boolean.parseBoolean(System.getProperty("james.protocols.mdc.hostname", "true"));

    public MDCBuilder onBound(Protocol var1, ChannelHandlerContext var2);

    public MDCBuilder withContext(ProtocolSession var1);

    public static MDCBuilder mdcContext(Protocol protocol, ChannelHandlerContext ctx) {
        MDCBuilder mdc = MDCBuilder.create().addToContext("protocol", protocol.getName()).addToContext("ip", ProtocolMDCContextFactory.retrieveIp(ctx));
        if (ADD_HOST_TO_MDC) {
            return mdc.addToContext("host", ProtocolMDCContextFactory.retrieveHost(ctx));
        }
        return mdc;
    }

    private static String retrieveIp(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.channel().remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getAddress().getHostAddress();
        }
        if (remoteAddress == null) {
            return "null";
        }
        return remoteAddress.toString();
    }

    private static String retrieveHost(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.channel().remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getHostName();
        }
        if (remoteAddress == null) {
            return "null";
        }
        return remoteAddress.toString();
    }

    public static MDCBuilder from(Object o) {
        return Optional.ofNullable(o).filter(ProtocolSession.class::isInstance).map(ProtocolSession.class::cast).map(ProtocolMDCContextFactory::forSession).orElse(MDCBuilder.create());
    }

    public static MDCBuilder forSession(ProtocolSession protocolSession) {
        return MDCBuilder.create().addToContext("sessionId", protocolSession.getSessionID()).addToContextIfPresent("user", Optional.ofNullable(protocolSession.getUsername()).map(Username::asString));
    }

    public static class Standard
    implements ProtocolMDCContextFactory {
        @Override
        public MDCBuilder onBound(Protocol protocol, ChannelHandlerContext ctx) {
            return ProtocolMDCContextFactory.mdcContext(protocol, ctx);
        }

        @Override
        public MDCBuilder withContext(ProtocolSession protocolSession) {
            return ProtocolMDCContextFactory.from(protocolSession);
        }
    }
}

