/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.List;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.VersionedKeyValueStore;
import org.apache.kafka.streams.state.VersionedRecord;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

abstract class AbstractReadWriteDecorator<T extends StateStore, K, V>
extends WrappedStateStore<T, K, V> {
    static final String ERROR_MESSAGE = "This method may only be called by Kafka Streams";

    private AbstractReadWriteDecorator(T inner) {
        super(inner);
    }

    @Override
    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    static StateStore getReadWriteStore(StateStore store) {
        if (store instanceof TimestampedKeyValueStore) {
            return new TimestampedKeyValueStoreReadWriteDecorator((TimestampedKeyValueStore)store);
        }
        if (store instanceof VersionedKeyValueStore) {
            return new VersionedKeyValueStoreReadWriteDecorator((VersionedKeyValueStore)store);
        }
        if (store instanceof KeyValueStore) {
            return new KeyValueStoreReadWriteDecorator((KeyValueStore)store);
        }
        if (store instanceof TimestampedWindowStore) {
            return new TimestampedWindowStoreReadWriteDecorator((TimestampedWindowStore)store);
        }
        if (store instanceof WindowStore) {
            return new WindowStoreReadWriteDecorator((WindowStore)store);
        }
        if (store instanceof SessionStore) {
            return new SessionStoreReadWriteDecorator((SessionStore)store);
        }
        return store;
    }

    /* synthetic */ AbstractReadWriteDecorator(StateStore x0, 1 x1) {
        this(x0);
    }

    static class SessionStoreReadWriteDecorator<K, AGG>
    extends AbstractReadWriteDecorator<SessionStore<K, AGG>, K, AGG>
    implements SessionStore<K, AGG> {
        SessionStoreReadWriteDecorator(SessionStore<K, AGG> inner) {
            super(inner, null);
        }

        @Override
        public KeyValueIterator<Windowed<K>, AGG> findSessions(K key, long earliestSessionEndTime, long latestSessionStartTime) {
            return ((SessionStore)this.wrapped()).findSessions(key, earliestSessionEndTime, latestSessionStartTime);
        }

        @Override
        public KeyValueIterator<Windowed<K>, AGG> findSessions(K keyFrom, K keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
            return ((SessionStore)this.wrapped()).findSessions(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
        }

        @Override
        public KeyValueIterator<Windowed<K>, AGG> findSessions(long earliestSessionEndTime, long latestSessionEndTime) {
            return ((SessionStore)this.wrapped()).findSessions(earliestSessionEndTime, latestSessionEndTime);
        }

        @Override
        public void remove(Windowed<K> sessionKey) {
            ((SessionStore)this.wrapped()).remove(sessionKey);
        }

        @Override
        public void put(Windowed<K> sessionKey, AGG aggregate) {
            ((SessionStore)this.wrapped()).put(sessionKey, aggregate);
        }

        @Override
        public AGG fetchSession(K key, long earliestSessionEndTime, long latestSessionStartTime) {
            return ((SessionStore)this.wrapped()).fetchSession(key, earliestSessionEndTime, latestSessionStartTime);
        }

        @Override
        public KeyValueIterator<Windowed<K>, AGG> fetch(K key) {
            return ((SessionStore)this.wrapped()).fetch(key);
        }

        @Override
        public KeyValueIterator<Windowed<K>, AGG> fetch(K keyFrom, K keyTo) {
            return ((SessionStore)this.wrapped()).fetch(keyFrom, keyTo);
        }
    }

    static class TimestampedWindowStoreReadWriteDecorator<K, V>
    extends WindowStoreReadWriteDecorator<K, ValueAndTimestamp<V>>
    implements TimestampedWindowStore<K, V> {
        TimestampedWindowStoreReadWriteDecorator(TimestampedWindowStore<K, V> inner) {
            super(inner);
        }
    }

    static class WindowStoreReadWriteDecorator<K, V>
    extends AbstractReadWriteDecorator<WindowStore<K, V>, K, V>
    implements WindowStore<K, V> {
        WindowStoreReadWriteDecorator(WindowStore<K, V> inner) {
            super(inner, null);
        }

        @Override
        public void put(K key, V value, long windowStartTimestamp) {
            ((WindowStore)this.wrapped()).put(key, value, windowStartTimestamp);
        }

        @Override
        public V fetch(K key, long time) {
            return ((WindowStore)this.wrapped()).fetch(key, time);
        }

        @Override
        public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
            return ((WindowStore)this.wrapped()).fetch(key, timeFrom, timeTo);
        }

        @Override
        public WindowStoreIterator<V> backwardFetch(K key, long timeFrom, long timeTo) {
            return ((WindowStore)this.wrapped()).backwardFetch(key, timeFrom, timeTo);
        }

        @Override
        public KeyValueIterator<Windowed<K>, V> fetch(K keyFrom, K keyTo, long timeFrom, long timeTo) {
            return ((WindowStore)this.wrapped()).fetch(keyFrom, keyTo, timeFrom, timeTo);
        }

        @Override
        public KeyValueIterator<Windowed<K>, V> backwardFetch(K keyFrom, K keyTo, long timeFrom, long timeTo) {
            return ((WindowStore)this.wrapped()).backwardFetch(keyFrom, keyTo, timeFrom, timeTo);
        }

        @Override
        public KeyValueIterator<Windowed<K>, V> fetchAll(long timeFrom, long timeTo) {
            return ((WindowStore)this.wrapped()).fetchAll(timeFrom, timeTo);
        }

        @Override
        public KeyValueIterator<Windowed<K>, V> backwardFetchAll(long timeFrom, long timeTo) {
            return ((WindowStore)this.wrapped()).backwardFetchAll(timeFrom, timeTo);
        }

        @Override
        public KeyValueIterator<Windowed<K>, V> all() {
            return ((WindowStore)this.wrapped()).all();
        }

        @Override
        public KeyValueIterator<Windowed<K>, V> backwardAll() {
            return ((WindowStore)this.wrapped()).backwardAll();
        }
    }

    static class VersionedKeyValueStoreReadWriteDecorator<K, V>
    extends AbstractReadWriteDecorator<VersionedKeyValueStore<K, V>, K, V>
    implements VersionedKeyValueStore<K, V> {
        VersionedKeyValueStoreReadWriteDecorator(VersionedKeyValueStore<K, V> inner) {
            super(inner, null);
        }

        @Override
        public long put(K key, V value, long timestamp) {
            return ((VersionedKeyValueStore)this.wrapped()).put(key, value, timestamp);
        }

        @Override
        public VersionedRecord<V> delete(K key, long timestamp) {
            return ((VersionedKeyValueStore)this.wrapped()).delete(key, timestamp);
        }

        @Override
        public VersionedRecord<V> get(K key) {
            return ((VersionedKeyValueStore)this.wrapped()).get(key);
        }

        @Override
        public VersionedRecord<V> get(K key, long asOfTimestamp) {
            return ((VersionedKeyValueStore)this.wrapped()).get(key, asOfTimestamp);
        }
    }

    static class TimestampedKeyValueStoreReadWriteDecorator<K, V>
    extends KeyValueStoreReadWriteDecorator<K, ValueAndTimestamp<V>>
    implements TimestampedKeyValueStore<K, V> {
        TimestampedKeyValueStoreReadWriteDecorator(TimestampedKeyValueStore<K, V> inner) {
            super(inner);
        }
    }

    static class KeyValueStoreReadWriteDecorator<K, V>
    extends AbstractReadWriteDecorator<KeyValueStore<K, V>, K, V>
    implements KeyValueStore<K, V> {
        KeyValueStoreReadWriteDecorator(KeyValueStore<K, V> inner) {
            super(inner, null);
        }

        @Override
        public V get(K key) {
            return ((KeyValueStore)this.wrapped()).get(key);
        }

        @Override
        public KeyValueIterator<K, V> range(K from, K to) {
            return ((KeyValueStore)this.wrapped()).range(from, to);
        }

        @Override
        public KeyValueIterator<K, V> reverseRange(K from, K to) {
            return ((KeyValueStore)this.wrapped()).reverseRange(from, to);
        }

        @Override
        public KeyValueIterator<K, V> all() {
            return ((KeyValueStore)this.wrapped()).all();
        }

        @Override
        public KeyValueIterator<K, V> reverseAll() {
            return ((KeyValueStore)this.wrapped()).reverseAll();
        }

        @Override
        public <PS extends Serializer<P>, P> KeyValueIterator<K, V> prefixScan(P prefix, PS prefixKeySerializer) {
            return ((KeyValueStore)this.wrapped()).prefixScan(prefix, prefixKeySerializer);
        }

        @Override
        public long approximateNumEntries() {
            return ((KeyValueStore)this.wrapped()).approximateNumEntries();
        }

        @Override
        public void put(K key, V value) {
            ((KeyValueStore)this.wrapped()).put(key, value);
        }

        @Override
        public V putIfAbsent(K key, V value) {
            return ((KeyValueStore)this.wrapped()).putIfAbsent(key, value);
        }

        @Override
        public void putAll(List<KeyValue<K, V>> entries) {
            ((KeyValueStore)this.wrapped()).putAll(entries);
        }

        @Override
        public V delete(K key) {
            return ((KeyValueStore)this.wrapped()).delete(key);
        }
    }
}

