/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiTimeSeriesData;
import com.cloudera.api.swagger.model.ApiTimeSeriesMetadata;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A time series represents a stream of data points. Each data point contains a time and a value. Time series are returned by executing a tsquery.")
public class ApiTimeSeries {
    @SerializedName(value="metadata")
    private ApiTimeSeriesMetadata metadata = null;
    @SerializedName(value="data")
    private List<ApiTimeSeriesData> data = null;

    public ApiTimeSeries metadata(ApiTimeSeriesMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="Metadata for the metric.")
    public ApiTimeSeriesMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ApiTimeSeriesMetadata metadata) {
        this.metadata = metadata;
    }

    public ApiTimeSeries data(List<ApiTimeSeriesData> data) {
        this.data = data;
        return this;
    }

    public ApiTimeSeries addDataItem(ApiTimeSeriesData dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<ApiTimeSeriesData>();
        }
        this.data.add(dataItem);
        return this;
    }

    @ApiModelProperty(value="List of metric data points.")
    public List<ApiTimeSeriesData> getData() {
        return this.data;
    }

    public void setData(List<ApiTimeSeriesData> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiTimeSeries apiTimeSeries = (ApiTimeSeries)o;
        return Objects.equals(this.metadata, apiTimeSeries.metadata) && Objects.equals(this.data, apiTimeSeries.data);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiTimeSeries {\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

