/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitStringComparator
extends LdapComparator<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(BitStringComparator.class);

    public BitStringComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String bs1, String bs2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_13743_COMPARING_BITSTRING, (Object[])new Object[]{bs1, bs2}));
        }
        if (bs1 == bs2) {
            return 0;
        }
        if (bs1 == null || bs2 == null) {
            return bs1 == null ? -1 : 1;
        }
        char[] array1 = bs1.toCharArray();
        char[] array2 = bs2.toCharArray();
        int pos1 = bs1.indexOf(49);
        int pos2 = bs2.indexOf(49);
        if (pos1 == -1) {
            if (pos2 == -1) {
                return 0;
            }
            return -1;
        }
        if (pos2 == -1) {
            return 1;
        }
        int length1 = array1.length - pos1;
        int length2 = array2.length - pos2;
        if (length1 == length2) {
            for (int i = 0; i < length1; ++i) {
                int i1 = i + pos1;
                int i2 = i + pos2;
                if (array1[i1] < array2[i2]) {
                    return -1;
                }
                if (array1[i1] <= array2[i2]) continue;
                return 1;
            }
            return 0;
        }
        if (length1 < length2) {
            return -1;
        }
        return 1;
    }
}

