/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.MimeType;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterApplyDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterPathDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteFilterReader;

public class UrlRewriteUtil {
    public static String pickFirstRuleWithEqualsIgnoreCasePathMatch(UrlRewriteFilterContentDescriptor config, String name) {
        String rule = "*";
        if (config != null && !config.getSelectors().isEmpty() && name != null) {
            rule = "";
            for (UrlRewriteFilterPathDescriptor selector : config.getSelectors()) {
                if (!name.equalsIgnoreCase(selector.path())) continue;
                if (!(selector instanceof UrlRewriteFilterApplyDescriptor)) break;
                rule = ((UrlRewriteFilterApplyDescriptor)selector).rule();
                break;
            }
        }
        return rule;
    }

    public static UrlRewriteFilterContentDescriptor getRewriteFilterConfig(UrlRewriteRulesDescriptor config, String filterName, MimeType mimeType) {
        UrlRewriteFilterDescriptor filterConfig;
        UrlRewriteFilterContentDescriptor filterContentConfig = null;
        if (config != null && (filterConfig = config.getFilter(filterName)) != null) {
            filterContentConfig = filterConfig.getContent(mimeType);
        }
        return filterContentConfig;
    }

    public static String filterJavaScript(String inputValue, UrlRewriteFilterContentDescriptor config, UrlRewriteFilterReader filterReader, UrlRewriteFilterPathDescriptor.Compiler<Pattern> regexCompiler) {
        StringBuilder tbuff = new StringBuilder();
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(inputValue);
        if (config != null && !config.getSelectors().isEmpty()) {
            for (UrlRewriteFilterPathDescriptor selector : config.getSelectors()) {
                if (!(selector instanceof UrlRewriteFilterApplyDescriptor)) continue;
                UrlRewriteFilterApplyDescriptor apply = (UrlRewriteFilterApplyDescriptor)selector;
                Matcher matcher = ((Pattern)apply.compiledPath(regexCompiler)).matcher(sbuff);
                int index = 0;
                while (matcher.find()) {
                    int start = matcher.start();
                    int end = matcher.end();
                    if (start == -1 || end == -1) continue;
                    tbuff.append(sbuff, index, start);
                    String value = matcher.group();
                    value = filterReader.filterValueString(null, value, apply.rule());
                    tbuff.append(value);
                    index = end;
                }
                tbuff.append(sbuff, index, sbuff.length());
                sbuff.setLength(0);
                sbuff.append((CharSequence)tbuff);
                tbuff.setLength(0);
            }
        }
        return sbuff.toString();
    }
}

