/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.jndi;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.ldaptive.LdapException;
import org.ldaptive.provider.AbstractProviderConnectionFactory;
import org.ldaptive.provider.ConnectionException;
import org.ldaptive.provider.jndi.JndiProviderConfig;
import org.ldaptive.provider.jndi.JndiStartTLSConnection;
import org.ldaptive.provider.jndi.NamingExceptionUtils;

public class JndiStartTLSConnectionFactory
extends AbstractProviderConnectionFactory<JndiProviderConfig> {
    private final Map<String, Object> environment;
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;

    public JndiStartTLSConnectionFactory(String url, JndiProviderConfig config, Map<String, Object> env, SSLSocketFactory factory, HostnameVerifier verifier) {
        super(url, config);
        this.environment = env;
        this.sslSocketFactory = factory;
        this.hostnameVerifier = verifier;
    }

    @Override
    protected JndiStartTLSConnection createInternal(String url) throws LdapException {
        Hashtable<String, Object> env = new Hashtable<String, Object>(this.environment);
        env.put("java.naming.provider.url", url);
        JndiStartTLSConnection conn = null;
        boolean closeConn = false;
        try {
            conn = new JndiStartTLSConnection(new InitialLdapContext(env, null), (JndiProviderConfig)this.getProviderConfig());
            conn.setStartTlsResponse(this.startTLS(conn.getLdapContext()));
        }
        catch (NamingException e) {
            closeConn = true;
            throw new ConnectionException(e, NamingExceptionUtils.getResultCode(e.getClass()));
        }
        catch (IOException e) {
            closeConn = true;
            throw new ConnectionException(e);
        }
        catch (RuntimeException e) {
            closeConn = true;
            throw e;
        }
        finally {
            if (closeConn) {
                try {
                    if (conn != null) {
                        conn.close(null);
                    }
                }
                catch (LdapException e) {
                    this.logger.debug("Problem tearing down connection", (Throwable)e);
                }
            }
        }
        return conn;
    }

    protected StartTlsResponse startTLS(LdapContext ctx) throws NamingException, IOException {
        StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
        if (this.hostnameVerifier != null) {
            this.logger.trace("startTLS hostnameVerifier = {}", (Object)this.hostnameVerifier);
            tls.setHostnameVerifier(this.hostnameVerifier);
        }
        if (this.sslSocketFactory != null) {
            this.logger.trace("startTLS sslSocketFactory = {}", (Object)this.sslSocketFactory);
            tls.negotiate(this.sslSocketFactory);
        } else {
            tls.negotiate();
        }
        return tls;
    }

    @Override
    public String toString() {
        return String.format("[%s@%d::metadata=%s, environment=%s, providerConfig=%s, sslSocketFactory=%s, hostnameVerifier=%s]", this.getClass().getName(), this.hashCode(), this.getMetadata(), this.environment, this.getProviderConfig(), this.sslSocketFactory, this.hostnameVerifier);
    }
}

