/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.partition;

import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InvalidNameException;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.i18n.I18n;

public abstract class AbstractPartition
implements Partition {
    protected boolean initialized;
    protected Entry contextEntry;
    protected SchemaManager schemaManager;
    protected DnFactory dnFactory;
    protected String id;
    protected Dn suffixDn;
    private String contextCsn;
    protected volatile boolean ctxCsnChanged = false;

    @Override
    public void initialize() throws LdapException {
        if (this.initialized) {
            return;
        }
        try {
            this.doInit();
            this.initialized = true;
        }
        catch (Exception e) {
            throw new LdapOtherException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (!this.initialized) {
                try {
                    this.destroy(null);
                }
                catch (Exception e) {
                    throw new LdapOtherException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void repair() throws LdapException {
    }

    protected abstract void doDestroy(PartitionTxn var1) throws LdapException;

    protected abstract void doInit() throws InvalidNameException, LdapException;

    protected abstract void doRepair() throws LdapException;

    @Override
    public final void destroy(PartitionTxn partitionTxn) throws LdapException {
        try {
            this.doDestroy(partitionTxn);
        }
        finally {
            this.initialized = false;
        }
    }

    @Override
    public final boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    @Override
    public final SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.checkInitialized("id");
        this.id = id;
    }

    @Override
    public final Dn getSuffixDn() {
        return this.suffixDn;
    }

    @Override
    public void setSuffixDn(Dn suffixDn) throws LdapInvalidDnException {
        this.checkInitialized("suffixDn");
        this.suffixDn = suffixDn.isSchemaAware() ? suffixDn : new Dn(this.schemaManager, suffixDn);
    }

    @Override
    public void dumpIndex(PartitionTxn partitionTxn, OutputStream stream, String name) throws IOException {
        stream.write(Strings.getBytesUtf8((String)("Nothing to dump for index " + name)));
    }

    protected void checkInitialized(String property) {
        if (this.initialized) {
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_576, (Object[])new Object[]{property}));
        }
    }

    public Entry getContextEntry() {
        return this.contextEntry;
    }

    public void setContextEntry(Entry contextEntry) {
        this.contextEntry = contextEntry;
    }

    @Override
    public String getContextCsn(PartitionTxn partitionTxn) {
        return this.contextCsn;
    }

    protected void setContextCsn(String csn) {
        if (!csn.equals(this.contextCsn)) {
            this.contextCsn = csn;
            this.ctxCsnChanged = true;
        }
    }

    @Override
    public void sync() throws LdapException {
    }
}

