/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.apis.openid.OpenIdJsonTokenExtractor;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class KeycloakApi
extends DefaultApi20 {
    private static final ConcurrentMap<String, KeycloakApi> INSTANCES = new ConcurrentHashMap<String, KeycloakApi>();
    private final String baseUrlWithRealm;

    protected KeycloakApi(String baseUrlWithRealm) {
        this.baseUrlWithRealm = baseUrlWithRealm;
    }

    public static KeycloakApi instance() {
        return KeycloakApi.instance("http://localhost:8080/", "master");
    }

    public static KeycloakApi instance(String baseUrl, String realm) {
        KeycloakApi alreadyCreatedApi;
        String defaultBaseUrlWithRealm = KeycloakApi.composeBaseUrlWithRealm(baseUrl, realm);
        KeycloakApi api = (KeycloakApi)((Object)INSTANCES.get(defaultBaseUrlWithRealm));
        if (api == null && (alreadyCreatedApi = INSTANCES.putIfAbsent(defaultBaseUrlWithRealm, api = new KeycloakApi(defaultBaseUrlWithRealm))) != null) {
            return alreadyCreatedApi;
        }
        return api;
    }

    protected static String composeBaseUrlWithRealm(String baseUrl, String realm) {
        return baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "auth/realms/" + realm;
    }

    public String getAccessTokenEndpoint() {
        return this.baseUrlWithRealm + "/protocol/openid-connect/token";
    }

    protected String getAuthorizationBaseUrl() {
        return this.baseUrlWithRealm + "/protocol/openid-connect/auth";
    }

    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        return OpenIdJsonTokenExtractor.instance();
    }

    public String getRevokeTokenEndpoint() {
        throw new RuntimeException("Not implemented yet");
    }
}

