/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.commons.math3.linear;

import org.apache.hadoop.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.hadoop.shaded.org.apache.commons.math3.exception.util.Localizable;
import org.apache.hadoop.shaded.org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.hadoop.shaded.org.apache.commons.math3.linear.HessenbergTransformer;
import org.apache.hadoop.shaded.org.apache.commons.math3.linear.MatrixUtils;
import org.apache.hadoop.shaded.org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.hadoop.shaded.org.apache.commons.math3.linear.RealMatrix;
import org.apache.hadoop.shaded.org.apache.commons.math3.util.FastMath;
import org.apache.hadoop.shaded.org.apache.commons.math3.util.Precision;

class SchurTransformer {
    private static final int MAX_ITERATIONS = 100;
    private final double[][] matrixP;
    private final double[][] matrixT;
    private RealMatrix cachedP;
    private RealMatrix cachedT;
    private RealMatrix cachedPt;
    private final double epsilon = Precision.EPSILON;

    public SchurTransformer(RealMatrix matrix) {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        HessenbergTransformer transformer = new HessenbergTransformer(matrix);
        this.matrixT = transformer.getH().getData();
        this.matrixP = transformer.getP().getData();
        this.cachedT = null;
        this.cachedP = null;
        this.cachedPt = null;
        this.transform();
    }

    public RealMatrix getP() {
        if (this.cachedP == null) {
            this.cachedP = MatrixUtils.createRealMatrix(this.matrixP);
        }
        return this.cachedP;
    }

    public RealMatrix getPT() {
        if (this.cachedPt == null) {
            this.cachedPt = this.getP().transpose();
        }
        return this.cachedPt;
    }

    public RealMatrix getT() {
        if (this.cachedT == null) {
            this.cachedT = MatrixUtils.createRealMatrix(this.matrixT);
        }
        return this.cachedT;
    }

    private void transform() {
        int n = this.matrixT.length;
        double norm = this.getNorm();
        ShiftInfo shift = new ShiftInfo();
        int iteration = 0;
        int iu = n - 1;
        while (iu >= 0) {
            int il = this.findSmallSubDiagonalElement(iu, norm);
            if (il == iu) {
                this.matrixT[iu][iu] = this.matrixT[iu][iu] + shift.exShift;
                --iu;
                iteration = 0;
                continue;
            }
            if (il == iu - 1) {
                double p = (this.matrixT[iu - 1][iu - 1] - this.matrixT[iu][iu]) / 2.0;
                double q = p * p + this.matrixT[iu][iu - 1] * this.matrixT[iu - 1][iu];
                double[] dArray = this.matrixT[iu];
                int n2 = iu;
                dArray[n2] = dArray[n2] + shift.exShift;
                double[] dArray2 = this.matrixT[iu - 1];
                int n3 = iu - 1;
                dArray2[n3] = dArray2[n3] + shift.exShift;
                if (q >= 0.0) {
                    int i;
                    double z = FastMath.sqrt(FastMath.abs(q));
                    z = p >= 0.0 ? p + z : p - z;
                    double x = this.matrixT[iu][iu - 1];
                    double s2 = FastMath.abs(x) + FastMath.abs(z);
                    p = x / s2;
                    q = z / s2;
                    double r = FastMath.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (int j = iu - 1; j < n; ++j) {
                        z = this.matrixT[iu - 1][j];
                        this.matrixT[iu - 1][j] = q * z + p * this.matrixT[iu][j];
                        this.matrixT[iu][j] = q * this.matrixT[iu][j] - p * z;
                    }
                    for (i = 0; i <= iu; ++i) {
                        z = this.matrixT[i][iu - 1];
                        this.matrixT[i][iu - 1] = q * z + p * this.matrixT[i][iu];
                        this.matrixT[i][iu] = q * this.matrixT[i][iu] - p * z;
                    }
                    for (i = 0; i <= n - 1; ++i) {
                        z = this.matrixP[i][iu - 1];
                        this.matrixP[i][iu - 1] = q * z + p * this.matrixP[i][iu];
                        this.matrixP[i][iu] = q * this.matrixP[i][iu] - p * z;
                    }
                }
                iu -= 2;
                iteration = 0;
                continue;
            }
            this.computeShift(il, iu, iteration, shift);
            if (++iteration > 100) {
                throw new MaxCountExceededException((Localizable)LocalizedFormats.CONVERGENCE_FAILED, 100, new Object[0]);
            }
            double[] hVec = new double[3];
            int im = this.initQRStep(il, iu, shift, hVec);
            this.performDoubleQRStep(il, im, iu, shift, hVec);
        }
    }

    private double getNorm() {
        double norm = 0.0;
        for (int i = 0; i < this.matrixT.length; ++i) {
            for (int j = FastMath.max(i - 1, 0); j < this.matrixT.length; ++j) {
                norm += FastMath.abs(this.matrixT[i][j]);
            }
        }
        return norm;
    }

    private int findSmallSubDiagonalElement(int startIdx, double norm) {
        int l;
        for (l = startIdx; l > 0; --l) {
            double s2 = FastMath.abs(this.matrixT[l - 1][l - 1]) + FastMath.abs(this.matrixT[l][l]);
            if (s2 == 0.0) {
                s2 = norm;
            }
            if (FastMath.abs(this.matrixT[l][l - 1]) < this.epsilon * s2) break;
        }
        return l;
    }

    private void computeShift(int l, int idx, int iteration, ShiftInfo shift) {
        double s2;
        shift.x = this.matrixT[idx][idx];
        shift.w = 0.0;
        shift.y = 0.0;
        if (l < idx) {
            shift.y = this.matrixT[idx - 1][idx - 1];
            shift.w = this.matrixT[idx][idx - 1] * this.matrixT[idx - 1][idx];
        }
        if (iteration == 10) {
            shift.exShift += shift.x;
            int i = 0;
            while (i <= idx) {
                double[] dArray = this.matrixT[i];
                int n = i++;
                dArray[n] = dArray[n] - shift.x;
            }
            s2 = FastMath.abs(this.matrixT[idx][idx - 1]) + FastMath.abs(this.matrixT[idx - 1][idx - 2]);
            shift.x = 0.75 * s2;
            shift.y = 0.75 * s2;
            shift.w = -0.4375 * s2 * s2;
        }
        if (iteration == 30) {
            s2 = (shift.y - shift.x) / 2.0;
            if ((s2 = s2 * s2 + shift.w) > 0.0) {
                s2 = FastMath.sqrt(s2);
                if (shift.y < shift.x) {
                    s2 = -s2;
                }
                s2 = shift.x - shift.w / ((shift.y - shift.x) / 2.0 + s2);
                int i = 0;
                while (i <= idx) {
                    double[] dArray = this.matrixT[i];
                    int n = i++;
                    dArray[n] = dArray[n] - s2;
                }
                shift.exShift += s2;
                shift.w = 0.964;
                shift.y = 0.964;
                shift.x = 0.964;
            }
        }
    }

    private int initQRStep(int il, int iu, ShiftInfo shift, double[] hVec) {
        int im;
        for (im = iu - 2; im >= il; --im) {
            double rhs;
            double lhs;
            double z = this.matrixT[im][im];
            double r = shift.x - z;
            double s2 = shift.y - z;
            hVec[0] = (r * s2 - shift.w) / this.matrixT[im + 1][im] + this.matrixT[im][im + 1];
            hVec[1] = this.matrixT[im + 1][im + 1] - z - r - s2;
            hVec[2] = this.matrixT[im + 2][im + 1];
            if (im == il || (lhs = FastMath.abs(this.matrixT[im][im - 1]) * (FastMath.abs(hVec[1]) + FastMath.abs(hVec[2]))) < this.epsilon * (rhs = FastMath.abs(hVec[0]) * (FastMath.abs(this.matrixT[im - 1][im - 1]) + FastMath.abs(z) + FastMath.abs(this.matrixT[im + 1][im + 1])))) break;
        }
        return im;
    }

    private void performDoubleQRStep(int il, int im, int iu, ShiftInfo shift, double[] hVec) {
        int n = this.matrixT.length;
        double p = hVec[0];
        double q = hVec[1];
        double r = hVec[2];
        for (int k = im; k <= iu - 1; ++k) {
            boolean notlast;
            boolean bl = notlast = k != iu - 1;
            if (k != im) {
                p = this.matrixT[k][k - 1];
                q = this.matrixT[k + 1][k - 1];
                r = notlast ? this.matrixT[k + 2][k - 1] : 0.0;
                shift.x = FastMath.abs(p) + FastMath.abs(q) + FastMath.abs(r);
                if (!Precision.equals(shift.x, 0.0, this.epsilon)) {
                    p /= shift.x;
                    q /= shift.x;
                    r /= shift.x;
                }
            }
            if (shift.x == 0.0) break;
            double s2 = FastMath.sqrt(p * p + q * q + r * r);
            if (p < 0.0) {
                s2 = -s2;
            }
            if (s2 == 0.0) continue;
            if (k != im) {
                this.matrixT[k][k - 1] = -s2 * shift.x;
            } else if (il != im) {
                this.matrixT[k][k - 1] = -this.matrixT[k][k - 1];
            }
            shift.x = (p += s2) / s2;
            shift.y = q / s2;
            double z = r / s2;
            q /= p;
            r /= p;
            for (int j = k; j < n; ++j) {
                p = this.matrixT[k][j] + q * this.matrixT[k + 1][j];
                if (notlast) {
                    this.matrixT[k + 2][j] = this.matrixT[k + 2][j] - (p += r * this.matrixT[k + 2][j]) * z;
                }
                this.matrixT[k][j] = this.matrixT[k][j] - p * shift.x;
                this.matrixT[k + 1][j] = this.matrixT[k + 1][j] - p * shift.y;
            }
            for (int i = 0; i <= FastMath.min(iu, k + 3); ++i) {
                p = shift.x * this.matrixT[i][k] + shift.y * this.matrixT[i][k + 1];
                if (notlast) {
                    this.matrixT[i][k + 2] = this.matrixT[i][k + 2] - (p += z * this.matrixT[i][k + 2]) * r;
                }
                this.matrixT[i][k] = this.matrixT[i][k] - p;
                this.matrixT[i][k + 1] = this.matrixT[i][k + 1] - p * q;
            }
            int high = this.matrixT.length - 1;
            for (int i = 0; i <= high; ++i) {
                p = shift.x * this.matrixP[i][k] + shift.y * this.matrixP[i][k + 1];
                if (notlast) {
                    this.matrixP[i][k + 2] = this.matrixP[i][k + 2] - (p += z * this.matrixP[i][k + 2]) * r;
                }
                this.matrixP[i][k] = this.matrixP[i][k] - p;
                this.matrixP[i][k + 1] = this.matrixP[i][k + 1] - p * q;
            }
        }
        for (int i = im + 2; i <= iu; ++i) {
            this.matrixT[i][i - 2] = 0.0;
            if (i <= im + 2) continue;
            this.matrixT[i][i - 3] = 0.0;
        }
    }

    private static class ShiftInfo {
        double x;
        double y;
        double w;
        double exShift;

        private ShiftInfo() {
        }
    }
}

