/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class PerThreadPKLookup {
    private final String idFieldName;
    protected final TermsEnum[] termsEnums;
    protected final PostingsEnum[] postingsEnums;
    protected final Bits[] liveDocs;
    protected final int[] docBases;
    protected final int numEnums;
    protected final boolean hasDeletions;
    private final Map<IndexReader.CacheKey, Integer> enumIndexes;

    public PerThreadPKLookup(IndexReader reader, String idFieldName) throws IOException {
        this(reader, idFieldName, Collections.emptyMap(), null, null);
    }

    private PerThreadPKLookup(IndexReader reader, String idFieldName, Map<IndexReader.CacheKey, Integer> prevEnumIndexes, TermsEnum[] reusableTermsEnums, PostingsEnum[] reusablePostingsEnums) throws IOException {
        this.idFieldName = idFieldName;
        ArrayList leaves = new ArrayList(reader.leaves());
        leaves.sort((c1, c2) -> c2.reader().numDocs() - c1.reader().numDocs());
        this.termsEnums = new TermsEnum[leaves.size()];
        this.postingsEnums = new PostingsEnum[leaves.size()];
        this.liveDocs = new Bits[leaves.size()];
        this.docBases = new int[leaves.size()];
        this.enumIndexes = new HashMap<IndexReader.CacheKey, Integer>();
        int numEnums = 0;
        boolean hasDeletions = false;
        for (int i = 0; i < leaves.size(); ++i) {
            IndexReader.CacheKey cacheKey;
            LeafReaderContext context = (LeafReaderContext)leaves.get(i);
            LeafReader leafReader = context.reader();
            IndexReader.CacheHelper cacheHelper = leafReader.getCoreCacheHelper();
            IndexReader.CacheKey cacheKey2 = cacheKey = cacheHelper == null ? null : cacheHelper.getKey();
            if (cacheKey != null && prevEnumIndexes.containsKey(cacheKey)) {
                int seg = prevEnumIndexes.get(cacheKey);
                this.termsEnums[numEnums] = reusableTermsEnums[seg];
                this.postingsEnums[numEnums] = reusablePostingsEnums[seg];
            } else {
                Terms terms = leafReader.terms(idFieldName);
                if (terms != null) {
                    this.termsEnums[numEnums] = terms.iterator();
                    assert (this.termsEnums[numEnums] != null);
                }
            }
            if (this.termsEnums[numEnums] == null) continue;
            if (cacheKey != null) {
                this.enumIndexes.put(cacheKey, numEnums);
            }
            this.docBases[numEnums] = context.docBase;
            this.liveDocs[numEnums] = leafReader.getLiveDocs();
            hasDeletions |= leafReader.hasDeletions();
            ++numEnums;
        }
        this.numEnums = numEnums;
        this.hasDeletions = hasDeletions;
    }

    public int lookup(BytesRef id) throws IOException {
        for (int seg = 0; seg < this.numEnums; ++seg) {
            if (!this.termsEnums[seg].seekExact(id)) continue;
            this.postingsEnums[seg] = this.termsEnums[seg].postings(this.postingsEnums[seg], 0);
            int docID = -1;
            while ((docID = this.postingsEnums[seg].nextDoc()) != Integer.MAX_VALUE) {
                if (this.liveDocs[seg] != null && !this.liveDocs[seg].get(docID)) continue;
                return this.docBases[seg] + docID;
            }
            assert (this.hasDeletions);
        }
        return -1;
    }

    public PerThreadPKLookup reopen(IndexReader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        return new PerThreadPKLookup(reader, this.idFieldName, this.enumIndexes, this.termsEnums, this.postingsEnums);
    }
}

