/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;

class TermsEnumTokenStream
extends TokenStream {
    private final BytesRefIterator termsEnum;
    private final CharTermAttribute charTerm = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

    public TermsEnumTokenStream(BytesRefIterator termsEnum) {
        this.termsEnum = termsEnum;
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        BytesRef bytes = this.termsEnum.next();
        if (bytes == null) {
            return false;
        }
        this.charTerm.setEmpty();
        this.charTerm.append(bytes.utf8ToString());
        return true;
    }
}

