/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Arrays;
import java.util.Collection;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.UnaryFunction;
import org.apache.sis.internal.feature.FeatureExpression;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.ScopedName;

final class ConvertFunction<R, S, V>
extends UnaryFunction<R, S>
implements FeatureExpression<R, V>,
Optimization.OnExpression<R, V> {
    private static final long serialVersionUID = 4686604324414717316L;
    private static final ScopedName NAME = ConvertFunction.createName("Convert");
    private final ObjectConverter<? super S, ? extends V> converter;

    ConvertFunction(Expression<? super R, ? extends S> expression, Class<S> clazz, Class<V> clazz2) {
        super(expression);
        this.converter = ObjectConverters.find(clazz, clazz2);
    }

    private ConvertFunction(ConvertFunction<R, S, V> convertFunction, Expression<? super R, ? extends S> expression) {
        super(expression);
        this.converter = convertFunction.converter;
    }

    @Override
    public Expression<R, V> recreate(Expression<? super R, ?>[] expressionArray) {
        Class<Object> clazz;
        Expression<R, ?> expression = expressionArray[0];
        if (expression instanceof FeatureExpression) {
            Class<?> clazz2;
            clazz = this.getValueClass();
            if (clazz.isAssignableFrom(clazz2 = ((FeatureExpression)expression).getValueClass())) {
                return expression;
            }
            if (clazz2 != Object.class) {
                return new ConvertFunction(expression, clazz2, clazz);
            }
        }
        clazz = this.converter.getSourceClass();
        return new ConvertFunction<R, Object, V>(this, expression.toValueType(clazz));
    }

    @Override
    public ScopedName getFunctionName() {
        return NAME;
    }

    @Override
    protected Collection<?> getChildren() {
        return Arrays.asList(this.expression, this.converter.getSourceClass(), this.converter.getTargetClass());
    }

    @Override
    public V apply(R r) {
        Object v = this.expression.apply(r);
        try {
            return this.converter.apply(v);
        }
        catch (UnconvertibleObjectException unconvertibleObjectException) {
            this.warning(unconvertibleObjectException, false);
            return null;
        }
    }

    @Override
    public Class<? extends V> getValueClass() {
        return this.converter.getTargetClass();
    }

    @Override
    public PropertyTypeBuilder expectedType(DefaultFeatureType defaultFeatureType, FeatureTypeBuilder featureTypeBuilder) {
        PropertyTypeBuilder propertyTypeBuilder = FeatureExpression.expectedType(this.expression, defaultFeatureType, featureTypeBuilder);
        if (propertyTypeBuilder instanceof AttributeTypeBuilder) {
            return ((AttributeTypeBuilder)propertyTypeBuilder).setValueClass(this.getValueClass());
        }
        return propertyTypeBuilder;
    }

    @Override
    public <N> Expression<R, N> toValueType(Class<N> clazz) {
        if (clazz.isAssignableFrom(this.getValueClass())) {
            return this;
        }
        Class<? super S> clazz2 = this.converter.getSourceClass();
        if (clazz.isAssignableFrom(clazz2)) {
            return this.expression;
        }
        try {
            return new ConvertFunction<R, S, N>(this.expression, clazz2, clazz);
        }
        catch (UnconvertibleObjectException unconvertibleObjectException) {
            throw (ClassCastException)new ClassCastException(Errors.format((short)8, this.expression.getFunctionName(), clazz)).initCause(unconvertibleObjectException);
        }
    }
}

