/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import ucar.units.PrefixDBException;
import ucar.units.PrefixDBImpl;
import ucar.units.PrefixExistsException;

public final class StandardPrefixDB
extends PrefixDBImpl {
    private static final long serialVersionUID = 1L;
    private static StandardPrefixDB instance = null;

    private StandardPrefixDB() throws PrefixExistsException {
        this.add("yotta", "Y", 1.0E24);
        this.add("zetta", "Z", 1.0E21);
        this.add("exa", "E", 1.0E18);
        this.add("peta", "P", 1.0E15);
        this.add("tera", "T", 1.0E12);
        this.add("giga", "G", 1.0E9);
        this.add("mega", "M", 1000000.0);
        this.add("kilo", "k", 1000.0);
        this.add("hecto", "h", 100.0);
        this.add("deca", "da", 10.0);
        this.addName("deka", 10.0);
        this.add("deci", "d", 0.1);
        this.add("centi", "c", 0.01);
        this.add("milli", "m", 0.001);
        this.add("micro", "u", 1.0E-6);
        this.add("nano", "n", 1.0E-9);
        this.add("pico", "p", 1.0E-12);
        this.add("femto", "f", 1.0E-15);
        this.add("atto", "a", 1.0E-18);
        this.add("zepto", "z", 1.0E-21);
        this.add("yocto", "y", 1.0E-24);
    }

    public static synchronized StandardPrefixDB instance() throws PrefixDBException {
        if (instance == null) {
            try {
                instance = new StandardPrefixDB();
            }
            catch (Exception e) {
                throw new PrefixDBException("Couldn't create standard prefix-database", e);
            }
        }
        return instance;
    }

    private void add(String name, String symbol, double definition) throws PrefixExistsException {
        this.addName(name, definition);
        this.addSymbol(symbol, definition);
    }

    public static void main(String[] args) throws Exception {
        StandardPrefixDB db = StandardPrefixDB.instance();
        System.out.println("db.getPrefixBySymbol(\"cm\") = \"" + db.getPrefixBySymbol("cm") + '\"');
        System.out.println("db.getPrefixBySymbol(\"dm\") = \"" + db.getPrefixBySymbol("dm") + '\"');
    }
}

