/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.util.MockFileSystem;
import org.apache.sshd.common.file.util.MockPath;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.scp.client.AbstractScpClient;
import org.apache.sshd.scp.client.DefaultScpStreamResolver;
import org.apache.sshd.scp.client.ScpClient;
import org.apache.sshd.scp.common.ScpFileOpener;
import org.apache.sshd.scp.common.ScpHelper;
import org.apache.sshd.scp.common.ScpTransferEventListener;
import org.apache.sshd.scp.common.helpers.DefaultScpFileOpener;
import org.apache.sshd.scp.common.helpers.ScpTimestampCommandDetails;

public class DefaultScpClient
extends AbstractScpClient {
    protected final ScpFileOpener opener;
    protected final ScpTransferEventListener listener;
    private final ClientSession clientSession;

    public DefaultScpClient(ClientSession clientSession) {
        this(clientSession, DefaultScpFileOpener.INSTANCE, ScpTransferEventListener.EMPTY);
    }

    public DefaultScpClient(ClientSession clientSession, ScpFileOpener fileOpener, ScpTransferEventListener eventListener) {
        this.clientSession = Objects.requireNonNull(clientSession, "No client session");
        this.opener = fileOpener == null ? DefaultScpFileOpener.INSTANCE : fileOpener;
        this.listener = eventListener == null ? ScpTransferEventListener.EMPTY : eventListener;
    }

    public ClientSession getClientSession() {
        return this.clientSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(String remote, OutputStream local) throws IOException {
        String cmd = ScpClient.createReceiveCommand(remote, Collections.emptyList());
        ClientSession session = this.getClientSession();
        ChannelExec channel = this.openCommandChannel(session, cmd);
        try (InputStream invOut = channel.getInvertedOut();
             OutputStream invIn = channel.getInvertedIn();){
            ScpHelper helper = new ScpHelper((Session)session, invOut, invIn, (FileSystem)new MockFileSystem(remote), this.opener, this.listener);
            helper.receiveFileStream(cmd, local, 8192);
            this.handleCommandExitStatus(cmd, (ClientChannel)channel);
        }
        finally {
            channel.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void download(String remote, FileSystem fs, Path local, Collection<ScpClient.Option> options) throws IOException {
        String cmd = ScpClient.createReceiveCommand(remote, options);
        ClientSession session = this.getClientSession();
        ChannelExec channel = this.openCommandChannel(session, cmd);
        try (InputStream invOut = channel.getInvertedOut();
             OutputStream invIn = channel.getInvertedIn();){
            ScpHelper helper = new ScpHelper((Session)session, invOut, invIn, fs, this.opener, this.listener);
            helper.receive(cmd, local, options.contains((Object)ScpClient.Option.Recursive), options.contains((Object)ScpClient.Option.TargetIsDirectory), options.contains((Object)ScpClient.Option.PreserveAttributes), 8192);
            this.handleCommandExitStatus(cmd, (ClientChannel)channel);
        }
        finally {
            channel.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(InputStream local, String remote, long size, Collection<PosixFilePermission> perms, ScpTimestampCommandDetails time) throws IOException {
        int namePos = ValidateUtils.checkNotNullAndNotEmpty((String)remote, (String)"No remote location specified").lastIndexOf(47);
        String name = namePos < 0 ? remote : ValidateUtils.checkNotNullAndNotEmpty((String)remote.substring(namePos + 1), (String)"No name value in remote=%s", (Object)remote);
        Set<ScpClient.Option> options = time != null ? EnumSet.of(ScpClient.Option.PreserveAttributes) : Collections.emptySet();
        String cmd = ScpClient.createSendCommand(remote, options);
        ClientSession session = this.getClientSession();
        ChannelExec channel = this.openCommandChannel(session, cmd);
        try {
            try (InputStream invOut = channel.getInvertedOut();
                 OutputStream invIn = channel.getInvertedIn();){
                ScpHelper helper = new ScpHelper((Session)session, invOut, invIn, (FileSystem)new MockFileSystem(remote), this.opener, this.listener);
                MockPath mockPath = new MockPath(remote);
                DefaultScpStreamResolver resolver = new DefaultScpStreamResolver(name, (Path)mockPath, perms, time, size, local, cmd);
                helper.readAndValidateOperationAck(cmd, resolver);
                helper.sendStream(resolver, options.contains((Object)ScpClient.Option.PreserveAttributes), 8192);
            }
            this.handleCommandExitStatus(cmd, (ClientChannel)channel);
        }
        finally {
            channel.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> void runUpload(String remote, Collection<ScpClient.Option> options, Collection<T> local, AbstractScpClient.ScpOperationExecutor<T> executor) throws IOException {
        local = ValidateUtils.checkNotNullAndNotEmpty(local, (String)"Invalid argument local: %s", (Object[])new Object[]{local});
        remote = ValidateUtils.checkNotNullAndNotEmpty((String)remote, (String)"Invalid argument remote: %s", (Object)remote);
        if (local.size() > 1) {
            options = this.addTargetIsDirectory(options);
        }
        String cmd = ScpClient.createSendCommand(remote, options);
        ClientSession session = this.getClientSession();
        ChannelExec channel = this.openCommandChannel(session, cmd);
        try {
            ClientFactoryManager manager = session.getFactoryManager();
            FileSystemFactory factory = manager.getFileSystemFactory();
            FileSystem fs = factory.createFileSystem((SessionContext)session);
            try (InputStream invOut = channel.getInvertedOut();
                 OutputStream invIn = channel.getInvertedIn();){
                ScpHelper helper = new ScpHelper((Session)session, invOut, invIn, fs, this.opener, this.listener);
                executor.execute(helper, local, options);
            }
            catch (Throwable throwable) {
                block37: {
                    try {
                        fs.close();
                    }
                    catch (UnsupportedOperationException e) {
                        if (!this.log.isDebugEnabled()) break block37;
                        this.log.debug("runUpload({}) {} => {} - failed ({}) to close file system={}: {}", new Object[]{session, remote, local, e.getClass().getSimpleName(), fs, e.getMessage()});
                    }
                }
                throw throwable;
            }
            try {
                fs.close();
            }
            catch (UnsupportedOperationException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("runUpload({}) {} => {} - failed ({}) to close file system={}: {}", new Object[]{session, remote, local, e.getClass().getSimpleName(), fs, e.getMessage()});
                }
            }
            this.handleCommandExitStatus(cmd, (ClientChannel)channel);
        }
        finally {
            channel.close(false);
        }
    }
}

