/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.contrib.common.channel.throttle;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.InterruptedByTimeoutException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriter;
import org.apache.sshd.common.channel.throttle.DefaultChannelStreamWriter;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class ThrottlingChannelStreamWriter
extends AbstractLoggingBean
implements ChannelStreamWriter,
SshFutureListener<IoWriteFuture> {
    public static final Property<Duration> WAIT_TIME = Property.durationSec((String)"packet-writer-wait-time", (Duration)Duration.ofSeconds(30L));
    public static final Property<Integer> MAX_PEND_COUNT = Property.integer((String)"packet-writer-max-pend-count", (int)4096);
    private final ChannelStreamWriter delegate;
    private final int maxPendingPackets;
    private final long maxWait;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final AtomicInteger availableCount;

    public ThrottlingChannelStreamWriter(Channel channel) {
        this((ChannelStreamWriter)new DefaultChannelStreamWriter(channel), (PropertyResolver)channel);
    }

    public ThrottlingChannelStreamWriter(ChannelStreamWriter delegate, PropertyResolver resolver) {
        this(delegate, (int)((Integer)MAX_PEND_COUNT.getRequired(resolver)), (Duration)WAIT_TIME.getRequired(resolver));
    }

    public ThrottlingChannelStreamWriter(ChannelStreamWriter delegate, int maxPendingPackets, TimeUnit waitUnit, long waitCount) {
        this(delegate, maxPendingPackets, waitUnit.toMillis(waitCount));
    }

    public ThrottlingChannelStreamWriter(ChannelStreamWriter delegate, int maxPendingPackets, Duration maxWait) {
        this(delegate, maxPendingPackets, maxWait.toMillis());
    }

    public ThrottlingChannelStreamWriter(ChannelStreamWriter delegate, int maxPendingPackets, long maxWait) {
        this.delegate = Objects.requireNonNull(delegate, "No delegate provided");
        ValidateUtils.checkTrue((maxPendingPackets > 0 ? 1 : 0) != 0, (String)"Invalid pending packets limit: %d", (long)maxPendingPackets);
        this.maxPendingPackets = maxPendingPackets;
        this.availableCount = new AtomicInteger(maxPendingPackets);
        ValidateUtils.checkTrue((maxWait > 0L ? 1 : 0) != 0, (String)"Invalid max. pending wait time: %d", (long)maxWait);
        this.maxWait = maxWait;
    }

    public ChannelStreamWriter getDelegate() {
        return this.delegate;
    }

    public int getMaxPendingPackets() {
        return this.maxPendingPackets;
    }

    public int getAvailablePacketsCount() {
        return this.availableCount.get();
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public boolean isOpen() {
        return this.open.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoWriteFuture writeData(Buffer buffer) throws IOException {
        int available;
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        long remainWait = this.getMaxWait();
        AtomicInteger atomicInteger = this.availableCount;
        synchronized (atomicInteger) {
            while (this.availableCount.get() == 0) {
                long waitStart = System.currentTimeMillis();
                try {
                    this.availableCount.wait(remainWait);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("Interrupted after " + (System.currentTimeMillis() - waitStart) + " msec.");
                }
                long waitDuration = System.currentTimeMillis() - waitStart;
                if (waitDuration <= 0L) {
                    waitDuration = 1L;
                }
                if ((remainWait -= waitDuration) > 0L) continue;
                throw new InterruptedByTimeoutException();
            }
            available = this.availableCount.decrementAndGet();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("writePacket({}) available={} after {} msec.", new Object[]{this, available, this.getMaxWait() - remainWait});
        }
        if (available < 0) {
            throw new EOFException("Negative available packets count: " + available);
        }
        ChannelStreamWriter writer = this.getDelegate();
        return (IoWriteFuture)writer.writeData(buffer).addListener((SshFutureListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationComplete(IoWriteFuture future) {
        if (future.isDone()) {
            if (future.isWritten()) {
                int available;
                AtomicInteger atomicInteger = this.availableCount;
                synchronized (atomicInteger) {
                    available = this.isOpen() ? this.availableCount.incrementAndGet() : Integer.MIN_VALUE;
                    this.availableCount.notifyAll();
                }
                if (available > 0) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("operationComplete({}) available={}", (Object)this, (Object)available);
                    }
                    return;
                }
                this.log.error("operationComplete({}) invalid available count: {}", (Object)this, (Object)available);
            } else {
                Throwable err = future.getException();
                this.log.error("operationComplete({}) Error ({}) signalled: {}", new Object[]{this, err.getClass().getSimpleName(), err.getMessage()});
            }
        } else {
            this.log.error("operationComplete({}) Incomplete future signalled: {}", (Object)this, (Object)future);
        }
        try {
            this.close();
        }
        catch (IOException e) {
            this.log.warn("operationComplete({}) unexpected ({}) due to close: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.open.getAndSet(false) && this.log.isDebugEnabled()) {
            this.log.debug("close({}) closing", (Object)this);
        }
        AtomicInteger atomicInteger = this.availableCount;
        synchronized (atomicInteger) {
            this.availableCount.set(-1);
            this.availableCount.notifyAll();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[delegate=" + this.getDelegate() + ", maxWait=" + this.getMaxWait() + ", maxPending=" + this.getMaxPendingPackets() + ", available=" + this.getAvailablePacketsCount() + "]";
    }
}

