/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Objects;
import org.apache.nifi.web.api.dto.NarCoordinateDTO;

@XmlType(name="narSummary")
public class NarSummaryDTO {
    private String identifier;
    private NarCoordinateDTO coordinate;
    private NarCoordinateDTO dependencyCoordinate;
    private String buildTime;
    private String createdBy;
    private String digest;
    private String sourceType;
    private String sourceIdentifier;
    private int extensionCount;
    private String state;
    private String failureMessage;
    private boolean installComplete;

    public NarSummaryDTO() {
    }

    public NarSummaryDTO(String identifier) {
        this.identifier = identifier;
    }

    @Schema(description="The identifier of the NAR.")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Schema(description="The coordinate of the NAR.")
    public NarCoordinateDTO getCoordinate() {
        return this.coordinate;
    }

    public void setCoordinate(NarCoordinateDTO coordinate) {
        this.coordinate = coordinate;
    }

    @Schema(description="The coordinate of another NAR that the this NAR is dependent on, or null if not dependent on another NAR.")
    public NarCoordinateDTO getDependencyCoordinate() {
        return this.dependencyCoordinate;
    }

    public void setDependencyCoordinate(NarCoordinateDTO dependencyCoordinate) {
        this.dependencyCoordinate = dependencyCoordinate;
    }

    @Schema(description="The time the NAR was built according to it's MANIFEST")
    public String getBuildTime() {
        return this.buildTime;
    }

    public void setBuildTime(String buildTime) {
        this.buildTime = buildTime;
    }

    @Schema(description="The plugin that created the NAR according to it's MANIFEST")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Schema(description="The hex digest of the NAR contents")
    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    @Schema(description="The source of this NAR")
    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    @Schema(description="The identifier of the source of this NAR")
    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    @Schema(description="The number of extensions contained in this NAR")
    public int getExtensionCount() {
        return this.extensionCount;
    }

    public void setExtensionCount(int extensionCount) {
        this.extensionCount = extensionCount;
    }

    @Schema(description="The state of the NAR (i.e. Installed, or not)")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Schema(description="Information about why the installation failed, only populated when the state is failed")
    public String getFailureMessage() {
        return this.failureMessage;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    @Schema(description="Indicates if the install task has completed")
    public boolean isInstallComplete() {
        return this.installComplete;
    }

    public void setInstallComplete(boolean installComplete) {
        this.installComplete = installComplete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NarSummaryDTO that = (NarSummaryDTO)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }
}

