/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxiedEntitiesUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProxiedEntitiesUtils.class);
    public static final String PROXY_ENTITIES_CHAIN = "X-ProxiedEntitiesChain";
    public static final String PROXY_ENTITIES_ACCEPTED = "X-ProxiedEntitiesAccepted";
    public static final String PROXY_ENTITIES_DETAILS = "X-ProxiedEntitiesDetails";
    private static final String GT = ">";
    private static final String ESCAPED_GT = "\\\\>";
    private static final String LT = "<";
    private static final String ESCAPED_LT = "\\\\<";
    private static final String ANONYMOUS_CHAIN = "<>";
    private static final String ANONYMOUS_IDENTITY = "";

    public static String getProxiedEntitiesChain(String ... proxiedEntities) {
        return ProxiedEntitiesUtils.getProxiedEntitiesChain(Arrays.asList(proxiedEntities));
    }

    public static String getProxiedEntitiesChain(List<String> proxiedEntities) {
        if (proxiedEntities == null) {
            return null;
        }
        List proxiedEntityChain = proxiedEntities.stream().map(ProxiedEntitiesUtils::formatProxyDn).collect(Collectors.toList());
        return StringUtils.join(proxiedEntityChain, (String)ANONYMOUS_IDENTITY);
    }

    public static List<String> tokenizeProxiedEntitiesChain(String rawProxyChain) {
        ArrayList<String> proxyChain = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)rawProxyChain)) {
            if (!ProxiedEntitiesUtils.isValidChainFormat(rawProxyChain)) {
                throw new IllegalArgumentException("Proxy chain format is not recognized and can not safely be converted to a list.");
            }
            if (rawProxyChain.equals(ANONYMOUS_CHAIN)) {
                proxyChain.add(ANONYMOUS_IDENTITY);
            } else {
                String[] elements = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)rawProxyChain.substring(1, rawProxyChain.length() - 1), (String)"><");
                Arrays.stream(elements).map(ProxiedEntitiesUtils::unsanitizeDn).forEach(proxyChain::add);
            }
        }
        return proxyChain;
    }

    public static String formatProxyDn(String dn) {
        return LT + ProxiedEntitiesUtils.sanitizeDn(dn) + GT;
    }

    private static String sanitizeDn(String rawDn) {
        if (StringUtils.isEmpty((CharSequence)rawDn)) {
            return rawDn;
        }
        String escapedDn = rawDn.replaceAll(GT, ESCAPED_GT).replaceAll(LT, ESCAPED_LT);
        if (!escapedDn.equals(rawDn)) {
            logger.warn("The provided DN [{}] contained dangerous characters that were escaped to [{}]", (Object)rawDn, (Object)escapedDn);
        }
        if (ProxiedEntitiesUtils.isPureAscii(escapedDn)) {
            return escapedDn;
        }
        String encodedDn = ProxiedEntitiesUtils.base64Encode(escapedDn);
        logger.debug("The provided DN [{}] contained non-ASCII characters and was encoded as [{}]", (Object)rawDn, (Object)encodedDn);
        return encodedDn;
    }

    private static String unsanitizeDn(String sanitizedDn) {
        String decodedDn;
        if (StringUtils.isEmpty((CharSequence)sanitizedDn)) {
            return sanitizedDn;
        }
        if (ProxiedEntitiesUtils.isBase64Encoded(sanitizedDn)) {
            decodedDn = ProxiedEntitiesUtils.base64Decode(sanitizedDn);
            logger.debug("The provided DN [{}] had been encoded, and was reconstituted to the original DN [{}]", (Object)sanitizedDn, (Object)decodedDn);
        } else {
            decodedDn = sanitizedDn;
        }
        String unsanitizedDn = decodedDn.replaceAll(ESCAPED_GT, GT).replaceAll(ESCAPED_LT, LT);
        if (!unsanitizedDn.equals(decodedDn)) {
            logger.warn("The provided DN [{}] had been escaped, and was reconstituted to the dangerous DN [{}]", (Object)sanitizedDn, (Object)unsanitizedDn);
        }
        return unsanitizedDn;
    }

    private static String base64Encode(String rawValue) {
        String base64String = Base64.getEncoder().encodeToString(rawValue.getBytes(StandardCharsets.UTF_8));
        String wrappedEncodedValue = LT + base64String + GT;
        return wrappedEncodedValue;
    }

    private static String base64Decode(String encodedValue) {
        String base64String = encodedValue.substring(1, encodedValue.length() - 1);
        return new String(Base64.getDecoder().decode(base64String), StandardCharsets.UTF_8);
    }

    private static boolean isValidChainFormat(String rawProxiedEntitiesChain) {
        return ProxiedEntitiesUtils.isWrappedInAngleBrackets(rawProxiedEntitiesChain);
    }

    private static boolean isBase64Encoded(String token) {
        return ProxiedEntitiesUtils.isWrappedInAngleBrackets(token);
    }

    private static boolean isWrappedInAngleBrackets(String string) {
        return string.startsWith(LT) && string.endsWith(GT);
    }

    private static boolean isPureAscii(String stringWithUnknownCharacters) {
        return StandardCharsets.US_ASCII.newEncoder().canEncode(stringWithUnknownCharacters);
    }
}

