/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.context;

import java.io.PrintStream;
import java.util.Objects;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.toolkit.cli.api.ClientFactory;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.api.Session;
import org.apache.nifi.toolkit.client.NiFiClient;

public class StandardContext
implements Context {
    private final ClientFactory<NiFiClient> niFiClientFactory;
    private final ClientFactory<NiFiRegistryClient> niFiRegistryClientFactory;
    private final Session session;
    private final PrintStream output;
    private final boolean isInteractive;

    private StandardContext(Builder builder) {
        this.niFiClientFactory = Objects.requireNonNull(builder.niFiClientFactory);
        this.niFiRegistryClientFactory = Objects.requireNonNull(builder.niFiRegistryClientFactory);
        this.session = Objects.requireNonNull(builder.session);
        this.output = Objects.requireNonNull(builder.output);
        this.isInteractive = builder.isInteractive;
    }

    @Override
    public ClientFactory<NiFiClient> getNiFiClientFactory() {
        return this.niFiClientFactory;
    }

    @Override
    public ClientFactory<NiFiRegistryClient> getNiFiRegistryClientFactory() {
        return this.niFiRegistryClientFactory;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public PrintStream getOutput() {
        return this.output;
    }

    @Override
    public boolean isInteractive() {
        return this.isInteractive;
    }

    public static class Builder {
        private ClientFactory<NiFiClient> niFiClientFactory;
        private ClientFactory<NiFiRegistryClient> niFiRegistryClientFactory;
        private Session session;
        private PrintStream output;
        private boolean isInteractive;

        public Builder nifiClientFactory(ClientFactory<NiFiClient> niFiClientFactory) {
            this.niFiClientFactory = niFiClientFactory;
            return this;
        }

        public Builder nifiRegistryClientFactory(ClientFactory<NiFiRegistryClient> niFiRegistryClientFactory) {
            this.niFiRegistryClientFactory = niFiRegistryClientFactory;
            return this;
        }

        public Builder session(Session session) {
            this.session = session;
            return this;
        }

        public Builder output(PrintStream output) {
            this.output = output;
            return this;
        }

        public Builder interactive(boolean isInteractive) {
            this.isInteractive = isInteractive;
            return this;
        }

        public StandardContext build() {
            return new StandardContext(this);
        }
    }
}

