/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.process;

import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.bootstrap.process.AbstractFileBasedRuntimeValidator;
import org.apache.nifi.bootstrap.process.RuntimeValidatorResult;

public class ForkedProcesses
extends AbstractFileBasedRuntimeValidator {
    private static final String FILE_PATH = String.format("/proc/%s/limits", ProcessHandle.current().pid());
    private static final Pattern PATTERN = Pattern.compile("Max processes\\s+(\\d+)\\s+(\\d+)\\s+processes\\s+");
    private static final int RECOMMENDED_SOFT_LIMIT = 10000;
    private static final int RECOMMENDED_HARD_LIMIT = 10000;

    public ForkedProcesses() {
        super(new File(FILE_PATH));
    }

    ForkedProcesses(File configurationFile) {
        super(configurationFile);
    }

    @Override
    protected Pattern getPattern() {
        return PATTERN;
    }

    @Override
    protected void performChecks(Matcher matcher, List<RuntimeValidatorResult> results) {
        String configurationPath = this.getConfigurationFile().getPath();
        if (matcher.find()) {
            RuntimeValidatorResult result;
            int softLimit = Integer.parseInt(matcher.group(1));
            int hardLimit = Integer.parseInt(matcher.group(2));
            if (softLimit < 10000) {
                result = this.getResultBuilder(RuntimeValidatorResult.Outcome.FAILED).explanation(String.format("Soft limit [%d] less than recommended [%d] according to [%s]", softLimit, 10000, configurationPath)).build();
                results.add(result);
            }
            if (hardLimit < 10000) {
                result = this.getResultBuilder(RuntimeValidatorResult.Outcome.FAILED).explanation(String.format("Hard limit [%d] less than recommended [%d] according to [%s]", hardLimit, 10000, configurationPath)).build();
                results.add(result);
            }
        } else {
            RuntimeValidatorResult result = this.getResultBuilder(RuntimeValidatorResult.Outcome.FAILED).explanation(String.format("Configuration file [%s] cannot be parsed", configurationPath)).build();
            results.add(result);
        }
    }
}

