# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import collections.abc
import datetime
import os
import pathlib
import typing

import typing_extensions

import opendal.file
import opendal.services
import opendal.types
from opendal.capability import Capability
from opendal.file import File
from opendal.layers import Layer
from opendal.types import Metadata

@typing.final
class AsyncOperator:
    r"""
    The async equivalent of `Operator`.

    `AsyncOperator` is the entry point for all async APIs.

    See Also
    --------
    Operator
    """

    def layer(self, layer: Layer) -> AsyncOperator:
        r"""
        Add a new layer to the operator.

        Parameters
        ----------
        layer : Layer
            The layer to add.

        Returns
        -------
        AsyncOperator
            A new operator with the layer added.
        """
    def open(
        self,
        path: builtins.str | os.PathLike | pathlib.Path,
        mode: builtins.str,
        **kwargs: typing.Any,
    ) -> collections.abc.Awaitable[opendal.file.AsyncFile]:
        r"""
        Open an async file-like object for the given path.

        The returning async file-like object is a context manager.

        Parameters
        ----------
        path : str
            The path to the file.
        mode : str
            The mode to open the file in. Only "rb" and "wb" are supported.
        **kwargs : dict
            Additional options for the underlying reader or writer.

        Returns
        -------
        coroutine
            An awaitable that returns a file-like object.
        """
    def read(
        self,
        path: builtins.str | os.PathLike | pathlib.Path,
        *,
        version: builtins.str | None = None,
        concurrent: builtins.int | None = None,
        chunk: builtins.int | None = None,
        gap: builtins.int | None = None,
        offset: builtins.int | None = None,
        prefetch: builtins.int | None = None,
        size: builtins.int | None = None,
        if_match: builtins.str | None = None,
        if_none_match: builtins.str | None = None,
        if_modified_since: datetime.datetime = None,
        if_unmodified_since: datetime.datetime = None,
        content_type: builtins.str | None = None,
        cache_control: builtins.str | None = None,
        content_disposition: builtins.str | None = None,
    ) -> collections.abc.Awaitable[builtins.bytes]:
        r"""
        Read the entire contents of a file at the given path.

        Parameters
        ----------
        path : str
            The path to the file.
        version : str, optional
            The version of the file.
        concurrent : int, optional
            The number of concurrent readers.
        chunk : int, optional
            The size of each chunk.
        gap : int, optional
            The gap between each chunk.
        offset : int, optional
            The offset of the file.
        prefetch : int, optional
            The number of bytes to prefetch.
        size : int, optional
            The size of the file.
        if_match : str, optional
            The ETag of the file.
        if_none_match : str, optional
            The ETag of the file.
        if_modified_since : str, optional
            The last modified time of the file.
        if_unmodified_since : str, optional
            The last modified time of the file.
        content_type : str, optional
            The content type of the file.
        cache_control : str, optional
            The cache control of the file.
        content_disposition : str, optional
            The content disposition of the file.

        Returns
        -------
        coroutine
            An awaitable that returns the contents of the file as bytes.
        """
    def write(
        self,
        path: builtins.str | os.PathLike | pathlib.Path,
        bs: builtins.bytes,
        *,
        append: builtins.bool | None = None,
        chunk: builtins.int | None = None,
        concurrent: builtins.int | None = None,
        cache_control: builtins.str | None = None,
        content_type: builtins.str | None = None,
        content_disposition: builtins.str | None = None,
        content_encoding: builtins.str | None = None,
        if_match: builtins.str | None = None,
        if_none_match: builtins.str | None = None,
        if_not_exists: builtins.bool | None = None,
        user_metadata: typing.Mapping[builtins.str, builtins.str] | None = None,
    ) -> collections.abc.Awaitable[None]:
        r"""
        Write bytes to a file at the given path.

        This function will create a file if it does not exist, and will
        overwrite its contents if it does.

        Parameters
        ----------
        path : str
            The path to the file.
        bs : bytes
            The contents to write to the file.
        append : bool, optional
            Whether to append to the file instead of overwriting it.
        chunk : int, optional
            The chunk size to use when writing the file.
        concurrent : int, optional
            The number of concurrent requests to make when writing the file.
        cache_control : str, optional
            The cache control header to set on the file.
        content_type : str, optional
            The content type header to set on the file.
        content_disposition : str, optional
            The content disposition header to set on the file.
        content_encoding : str, optional
            The content encoding header to set on the file.
        if_match : str, optional
            The ETag to match when writing the file.
        if_none_match : str, optional
            The ETag to not match when writing the file.
        if_not_exists : bool, optional
            Whether to fail if the file already exists.
        user_metadata : dict, optional
            The user metadata to set on the file.

        Returns
        -------
        coroutine
            An awaitable that completes when the write is finished.
        """
    def stat(
        self,
        path: builtins.str | os.PathLike | pathlib.Path,
        *,
        version: builtins.str | None = None,
        if_match: builtins.str | None = None,
        if_none_match: builtins.str | None = None,
        if_modified_since: datetime.datetime = None,
        if_unmodified_since: datetime.datetime = None,
        content_type: builtins.str | None = None,
        cache_control: builtins.str | None = None,
        content_disposition: builtins.str | None = None,
    ) -> collections.abc.Awaitable[Metadata]:
        r"""
        Get the metadata of a file at the given path.

        Parameters
        ----------
        path : str
            The path to the file.
        version : str, optional
            The version of the file.
        if_match : str, optional
            The ETag of the file.
        if_none_match : str, optional
            The ETag of the file.
        if_modified_since : datetime, optional
            The last modified time of the file.
        if_unmodified_since : datetime, optional
            The last modified time of the file.
        content_type : str, optional
            The content type of the file.
        cache_control : str, optional
            The cache control of the file.
        content_disposition : str, optional
            The content disposition of the file.

        Returns
        -------
        coroutine
            An awaitable that returns the metadata of the file.
        """
    def copy(
        self,
        source: builtins.str | os.PathLike | pathlib.Path,
        target: builtins.str | os.PathLike | pathlib.Path,
    ) -> collections.abc.Awaitable[None]:
        r"""
        Copy a file from one path to another.

        Parameters
        ----------
        source : str
            The path to the source file.
        target : str
            The path to the target file.

        Returns
        -------
        coroutine
            An awaitable that completes when the copy is finished.
        """
    def rename(
        self,
        source: builtins.str | os.PathLike | pathlib.Path,
        target: builtins.str | os.PathLike | pathlib.Path,
    ) -> collections.abc.Awaitable[None]:
        r"""
        Rename (move) a file from one path to another.

        Parameters
        ----------
        source : str
            The path to the source file.
        target : str
            The path to the target file.

        Returns
        -------
        coroutine
            An awaitable that completes when the rename is finished.
        """
    def remove_all(
        self, path: builtins.str | os.PathLike | pathlib.Path
    ) -> collections.abc.Awaitable[None]:
        r"""
        Recursively remove all files and directories at the given path.

        Parameters
        ----------
        path : str
            The path to remove.

        Returns
        -------
        coroutine
            An awaitable that completes when the removal is finished.
        """
    def check(self) -> collections.abc.Awaitable[None]:
        r"""
        Check if the operator is able to work correctly.

        Returns
        -------
        coroutine
            An awaitable that completes when the check is finished.

        Raises
        ------
        Exception
            If the operator is not able to work correctly.
        """
    def create_dir(
        self, path: builtins.str | os.PathLike | pathlib.Path
    ) -> collections.abc.Awaitable[None]:
        r"""
        Create a directory at the given path.

        Notes
        -----
        To indicate that a path is a directory, it must end with a `/`.
        This operation is always recursive, like `mkdir -p`.

        Parameters
        ----------
        path : str
            The path to the directory.

        Returns
        -------
        coroutine
            An awaitable that completes when the directory is created.
        """
    def delete(
        self, path: builtins.str | os.PathLike | pathlib.Path
    ) -> collections.abc.Awaitable[None]:
        r"""
        Delete a file at the given path.

        Notes
        -----
        This operation will not return an error if the path does not exist.

        Parameters
        ----------
        path : str
            The path to the file.

        Returns
        -------
        coroutine
            An awaitable that completes when the file is deleted.
        """
    def exists(
        self, path: builtins.str | os.PathLike | pathlib.Path
    ) -> collections.abc.Awaitable[builtins.bool]:
        r"""
        Check if a path exists.

        Parameters
        ----------
        path : str
            The path to check.

        Returns
        -------
        coroutine
            An awaitable that returns True if the path exists, False otherwise.
        """
    def list(
        self,
        path: builtins.str | os.PathLike | pathlib.Path,
        *,
        limit: builtins.int | None = None,
        start_after: builtins.str | None = None,
        recursive: builtins.bool | None = None,
        versions: builtins.bool | None = None,
        deleted: builtins.bool | None = None,
    ) -> collections.abc.Awaitable[collections.abc.AsyncIterable[opendal.types.Entry]]:
        r"""
        List entries in the given directory.

        Parameters
        ----------
        path : str
            The path to the directory.
        limit : int, optional
            The maximum number of entries to return.
        start_after : str, optional
            The entry to start after.
        recursive : bool, optional
            Whether to list recursively.
        versions : bool, optional
            Whether to list versions.
        deleted : bool, optional
            Whether to list deleted entries.

        Returns
        -------
        coroutine
            An awaitable that returns an async iterator over the entries.
        """
    def presign_stat(
        self,
        path: builtins.str | os.PathLike | pathlib.Path,
        expire_second: builtins.int,
    ) -> collections.abc.Awaitable[opendal.types.PresignedRequest]:
        r"""
        Create a presigned request for a stat operation.

        Parameters
        ----------
        path : str
            The path of the object to stat.
        expire_second : int
            The number of seconds until the presigned URL expires.

        Returns
        -------
        coroutine
            An awaitable that returns a presigned request object.
        """
    def presign_read(
        self,
        path: builtins.str | os.PathLike | pathlib.Path,
        expire_second: builtins.int,
    ) -> collections.abc.Awaitable[opendal.types.PresignedRequest]:
        r"""
        Create a presigned request for a read operation.

        Parameters
        ----------
        path : str
            The path of the object to read.
        expire_second : int
            The number of seconds until the presigned URL expires.

        Returns
        -------
        coroutine
            An awaitable that returns a presigned request object.
        """
    def presign_write(
        self,
        path: builtins.str | os.PathLike | pathlib.Path,
        expire_second: builtins.int,
    ) -> collections.abc.Awaitable[opendal.types.PresignedRequest]:
        r"""
        Create a presigned request for a write operation.

        Parameters
        ----------
        path : str
            The path of the object to write to.
        expire_second : int
            The number of seconds until the presigned URL expires.

        Returns
        -------
        coroutine
            An awaitable that returns a presigned request object.
        """
    def presign_delete(
        self,
        path: builtins.str | os.PathLike | pathlib.Path,
        expire_second: builtins.int,
    ) -> collections.abc.Awaitable[opendal.types.PresignedRequest]:
        r"""
        Create a presigned request for a delete operation.

        Parameters
        ----------
        path : str
            The path of the object to delete.
        expire_second : int
            The number of seconds until the presigned URL expires.

        Returns
        -------
        coroutine
            An awaitable that returns a presigned request object.
        """
    def capability(self) -> Capability:
        r"""
        Get all capabilities of this operator.

        Returns
        -------
        Capability
            The capability of the operator.
        """
    def to_operator(self) -> Operator:
        r"""
        Create a new blocking `Operator` from this async operator.

        Returns
        -------
        Operator
            The blocking operator.
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.AliyunDrive | typing.Literal["aliyun-drive"],
        /,
        *,
        access_token: builtins.str = ...,
        client_id: builtins.str = ...,
        client_secret: builtins.str = ...,
        drive_type: builtins.str,
        refresh_token: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `aliyun-drive` service.

        Parameters
        ----------
        access_token : builtins.str, optional
            The access_token of this backend.
            Solution for client-only purpose.
            #4733 Required if no client_id, client_secret and
            refresh_token are provided.
        client_id : builtins.str, optional
            The client_id of this backend.
            Required if no access_token is provided.
        client_secret : builtins.str, optional
            The client_secret of this backend.
            Required if no access_token is provided.
        drive_type : builtins.str
            The drive_type of this backend.
            All operations will happen under this type of drive.
            Available values are `default`, `backup` and
            `resource`.
            Fallback to default if not set or no other drives
            can be found.
        refresh_token : builtins.str, optional
            The refresh_token of this backend.
            Required if no access_token is provided.
        root : builtins.str, optional
            The Root of this backend.
            All operations will happen under this root.
            Default to `/` if not set.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `aliyun-drive` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Alluxio | typing.Literal["alluxio"],
        /,
        *,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `alluxio` service.

        Parameters
        ----------
        endpoint : builtins.str, optional
            endpoint of this backend.
            Endpoint must be full uri, mostly like
            `http://127.0.0.1:39999`.
        root : builtins.str, optional
            root of this backend.
            All operations will happen under this root.
            default to `/` if not set.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `alluxio` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Azblob | typing.Literal["azblob"],
        /,
        *,
        account_key: builtins.str = ...,
        account_name: builtins.str = ...,
        batch_max_operations: builtins.int = ...,
        container: builtins.str,
        encryption_algorithm: builtins.str = ...,
        encryption_key: builtins.str = ...,
        encryption_key_sha256: builtins.str = ...,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
        sas_token: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `azblob` service.

        Parameters
        ----------
        account_key : builtins.str, optional
            The account key of Azblob service backend.
        account_name : builtins.str, optional
            The account name of Azblob service backend.
        batch_max_operations : builtins.int, optional
            The maximum batch operations of Azblob service
            backend.
        container : builtins.str
            The container name of Azblob service backend.
        encryption_algorithm : builtins.str, optional
            The encryption algorithm of Azblob service backend.
        encryption_key : builtins.str, optional
            The encryption key of Azblob service backend.
        encryption_key_sha256 : builtins.str, optional
            The encryption key sha256 of Azblob service backend.
        endpoint : builtins.str, optional
            The endpoint of Azblob service backend.
            Endpoint must be full uri, e.g.
            - Azblob:
            `https://accountname.blob.core.windows.net` -
            Azurite: `http://127.0.0.1:10000/devstoreaccount1`
        root : builtins.str, optional
            The root of Azblob service backend.
            All operations will happen under this root.
        sas_token : builtins.str, optional
            The sas token of Azblob service backend.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `azblob` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Azdls | typing.Literal["azdls"],
        /,
        *,
        account_key: builtins.str = ...,
        account_name: builtins.str = ...,
        authority_host: builtins.str = ...,
        client_id: builtins.str = ...,
        client_secret: builtins.str = ...,
        endpoint: builtins.str = ...,
        filesystem: builtins.str,
        root: builtins.str = ...,
        sas_token: builtins.str = ...,
        tenant_id: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `azdls` service.

        Parameters
        ----------
        account_key : builtins.str, optional
            Account key of this backend.
            - required for shared_key authentication
        account_name : builtins.str, optional
            Account name of this backend.
        authority_host : builtins.str, optional
            authority_host The authority host of the service
            principal.
            - required for client_credentials authentication -
            default value: `https://login.microsoftonline.com`
        client_id : builtins.str, optional
            client_id The client id of the service principal.
            - required for client_credentials authentication
        client_secret : builtins.str, optional
            client_secret The client secret of the service
            principal.
            - required for client_credentials authentication
        endpoint : builtins.str, optional
            Endpoint of this backend.
        filesystem : builtins.str
            Filesystem name of this backend.
        root : builtins.str, optional
            Root of this backend.
        sas_token : builtins.str, optional
            sas_token The shared access signature token.
            - required for sas authentication
        tenant_id : builtins.str, optional
            tenant_id The tenant id of the service principal.
            - required for client_credentials authentication

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `azdls` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Azfile | typing.Literal["azfile"],
        /,
        *,
        account_key: builtins.str = ...,
        account_name: builtins.str = ...,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
        sas_token: builtins.str = ...,
        share_name: builtins.str,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `azfile` service.

        Parameters
        ----------
        account_key : builtins.str, optional
            The account key for azfile.
        account_name : builtins.str, optional
            The account name for azfile.
        endpoint : builtins.str, optional
            The endpoint for azfile.
        root : builtins.str, optional
            The root path for azfile.
        sas_token : builtins.str, optional
            The sas token for azfile.
        share_name : builtins.str
            The share name for azfile.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `azfile` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.B2 | typing.Literal["b2"],
        /,
        *,
        application_key: builtins.str = ...,
        application_key_id: builtins.str = ...,
        bucket: builtins.str,
        bucket_id: builtins.str,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `b2` service.

        Parameters
        ----------
        application_key : builtins.str, optional
            applicationKey of this backend.
            - If application_key is set, we will take user's
            input first.
            - If not, we will try to load it from environment.
        application_key_id : builtins.str, optional
            keyID of this backend.
            - If application_key_id is set, we will take user's
            input first.
            - If not, we will try to load it from environment.
        bucket : builtins.str
            bucket of this backend.
            required.
        bucket_id : builtins.str
            bucket id of this backend.
            required.
        root : builtins.str, optional
            root of this backend.
            All operations will happen under this root.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `b2` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Cacache | typing.Literal["cacache"],
        /,
        *,
        datadir: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `cacache` service.

        Parameters
        ----------
        datadir : builtins.str, optional
            That path to the cacache data directory.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `cacache` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Cos | typing.Literal["cos"],
        /,
        *,
        bucket: builtins.str = ...,
        disable_config_load: builtins.bool = ...,
        enable_versioning: builtins.bool = ...,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
        secret_id: builtins.str = ...,
        secret_key: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `cos` service.

        Parameters
        ----------
        bucket : builtins.str, optional
            Bucket of this backend.
        disable_config_load : builtins.bool, optional
            Disable config load so that opendal will not load
            config from
        enable_versioning : builtins.bool, optional
            is bucket versioning enabled for this bucket
        endpoint : builtins.str, optional
            Endpoint of this backend.
        root : builtins.str, optional
            Root of this backend.
        secret_id : builtins.str, optional
            Secret ID of this backend.
        secret_key : builtins.str, optional
            Secret key of this backend.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `cos` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Dashmap | typing.Literal["dashmap"],
        /,
        *,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `dashmap` service.

        Parameters
        ----------
        root : builtins.str, optional
            root path of this backend

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `dashmap` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Dropbox | typing.Literal["dropbox"],
        /,
        *,
        access_token: builtins.str = ...,
        client_id: builtins.str = ...,
        client_secret: builtins.str = ...,
        refresh_token: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `dropbox` service.

        Parameters
        ----------
        access_token : builtins.str, optional
            access token for dropbox.
        client_id : builtins.str, optional
            client_id for dropbox.
        client_secret : builtins.str, optional
            client_secret for dropbox.
        refresh_token : builtins.str, optional
            refresh_token for dropbox.
        root : builtins.str, optional
            root path for dropbox.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `dropbox` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Fs | typing.Literal["fs"],
        /,
        *,
        atomic_write_dir: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `fs` service.

        Parameters
        ----------
        atomic_write_dir : builtins.str, optional
            tmp dir for atomic write
        root : builtins.str, optional
            root dir for backend

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `fs` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Ftp | typing.Literal["ftp"],
        /,
        *,
        endpoint: builtins.str = ...,
        password: builtins.str = ...,
        root: builtins.str = ...,
        user: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `ftp` service.

        Parameters
        ----------
        endpoint : builtins.str, optional
            endpoint of this backend
        password : builtins.str, optional
            password of this backend
        root : builtins.str, optional
            root of this backend
        user : builtins.str, optional
            user of this backend

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `ftp` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Gcs | typing.Literal["gcs"],
        /,
        *,
        allow_anonymous: builtins.bool = ...,
        bucket: builtins.str,
        credential: builtins.str = ...,
        credential_path: builtins.str = ...,
        default_storage_class: builtins.str = ...,
        disable_config_load: builtins.bool = ...,
        disable_vm_metadata: builtins.bool = ...,
        endpoint: builtins.str = ...,
        predefined_acl: builtins.str = ...,
        root: builtins.str = ...,
        scope: builtins.str = ...,
        service_account: builtins.str = ...,
        token: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `gcs` service.

        Parameters
        ----------
        allow_anonymous : builtins.bool, optional
            Allow opendal to send requests without signing when
            credentials are not loaded.
        bucket : builtins.str
            bucket name
        credential : builtins.str, optional
            Credentials string for GCS service OAuth2
            authentication.
        credential_path : builtins.str, optional
            Local path to credentials file for GCS service
            OAuth2 authentication.
        default_storage_class : builtins.str, optional
            The default storage class used by gcs.
        disable_config_load : builtins.bool, optional
            Disable loading configuration from the environment.
        disable_vm_metadata : builtins.bool, optional
            Disable attempting to load credentials from the GCE
            metadata server when running within Google Cloud.
        endpoint : builtins.str, optional
            endpoint URI of GCS service, default is
            `https://storage.googleapis.com`
        predefined_acl : builtins.str, optional
            The predefined acl for GCS.
        root : builtins.str, optional
            root URI, all operations happens under `root`
        scope : builtins.str, optional
            Scope for gcs.
        service_account : builtins.str, optional
            Service Account for gcs.
        token : builtins.str, optional
            A Google Cloud OAuth2 token.
            Takes precedence over `credential` and
            `credential_path`.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `gcs` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Gdrive | typing.Literal["gdrive"],
        /,
        *,
        access_token: builtins.str = ...,
        client_id: builtins.str = ...,
        client_secret: builtins.str = ...,
        refresh_token: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `gdrive` service.

        Parameters
        ----------
        access_token : builtins.str, optional
            Access token for gdrive.
        client_id : builtins.str, optional
            Client id for gdrive.
        client_secret : builtins.str, optional
            Client secret for gdrive.
        refresh_token : builtins.str, optional
            Refresh token for gdrive.
        root : builtins.str, optional
            The root for gdrive

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `gdrive` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Ghac | typing.Literal["ghac"],
        /,
        *,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
        runtime_token: builtins.str = ...,
        version: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `ghac` service.

        Parameters
        ----------
        endpoint : builtins.str, optional
            The endpoint for ghac service.
        root : builtins.str, optional
            The root path for ghac.
        runtime_token : builtins.str, optional
            The runtime token for ghac service.
        version : builtins.str, optional
            The version that used by cache.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `ghac` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Gridfs | typing.Literal["gridfs"],
        /,
        *,
        bucket: builtins.str = ...,
        chunk_size: builtins.int = ...,
        connection_string: builtins.str = ...,
        database: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `gridfs` service.

        Parameters
        ----------
        bucket : builtins.str, optional
            The bucket name of the MongoDB GridFs service to
            read/write.
        chunk_size : builtins.int, optional
            The chunk size of the MongoDB GridFs service used to
            break the user file into chunks.
        connection_string : builtins.str, optional
            The connection string of the MongoDB service.
        database : builtins.str, optional
            The database name of the MongoDB GridFs service to
            read/write.
        root : builtins.str, optional
            The working directory, all operations will be
            performed under it.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `gridfs` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.HdfsNative | typing.Literal["hdfs-native"],
        /,
        *,
        enable_append: builtins.bool = ...,
        name_node: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `hdfs-native` service.

        Parameters
        ----------
        enable_append : builtins.bool, optional
            enable the append capacity
        name_node : builtins.str, optional
            name_node of this backend
        root : builtins.str, optional
            work dir of this backend

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `hdfs-native` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Http | typing.Literal["http"],
        /,
        *,
        endpoint: builtins.str = ...,
        password: builtins.str = ...,
        root: builtins.str = ...,
        token: builtins.str = ...,
        username: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `http` service.

        Parameters
        ----------
        endpoint : builtins.str, optional
            endpoint of this backend
        password : builtins.str, optional
            password of this backend
        root : builtins.str, optional
            root of this backend
        token : builtins.str, optional
            token of this backend
        username : builtins.str, optional
            username of this backend

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `http` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Huggingface | typing.Literal["huggingface"],
        /,
        *,
        repo_id: builtins.str = ...,
        repo_type: builtins.str = ...,
        revision: builtins.str = ...,
        root: builtins.str = ...,
        token: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `huggingface` service.

        Parameters
        ----------
        repo_id : builtins.str, optional
            Repo id of this backend.
            This is required.
        repo_type : builtins.str, optional
            Repo type of this backend.
            Default is model.
            Available values: - model - dataset
        revision : builtins.str, optional
            Revision of this backend.
            Default is main.
        root : builtins.str, optional
            Root of this backend.
            Can be "/path/to/dir".
            Default is "/".
        token : builtins.str, optional
            Token of this backend.
            This is optional.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `huggingface` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Ipfs | typing.Literal["ipfs"],
        /,
        *,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `ipfs` service.

        Parameters
        ----------
        endpoint : builtins.str, optional
            IPFS gateway endpoint.
        root : builtins.str, optional
            IPFS root.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `ipfs` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Ipmfs | typing.Literal["ipmfs"],
        /,
        *,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `ipmfs` service.

        Parameters
        ----------
        endpoint : builtins.str, optional
            Endpoint for ipfs.
        root : builtins.str, optional
            Root for ipfs.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `ipmfs` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Koofr | typing.Literal["koofr"],
        /,
        *,
        email: builtins.str,
        endpoint: builtins.str,
        password: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `koofr` service.

        Parameters
        ----------
        email : builtins.str
            Koofr email.
        endpoint : builtins.str
            Koofr endpoint.
        password : builtins.str, optional
            password of this backend.
            (Must be the application password)
        root : builtins.str, optional
            root of this backend.
            All operations will happen under this root.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `koofr` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Memcached | typing.Literal["memcached"],
        /,
        *,
        connection_pool_max_size: builtins.int = ...,
        default_ttl: typing.Any = ...,
        endpoint: builtins.str = ...,
        password: builtins.str = ...,
        root: builtins.str = ...,
        username: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `memcached` service.

        Parameters
        ----------
        connection_pool_max_size : builtins.int, optional
            The maximum number of connections allowed.
            default is 10
        default_ttl : typing.Any, optional
            The default ttl for put operations..
            a human readable duration string see
            https://docs.rs/humantime/latest/humantime/fn.parse_duration.html
            for more details
        endpoint : builtins.str, optional
            network address of the memcached service.
            For example: "tcp://localhost:11211"
        password : builtins.str, optional
            Memcached password, optional.
        root : builtins.str, optional
            the working directory of the service.
            Can be "/path/to/dir" default is "/"
        username : builtins.str, optional
            Memcached username, optional.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `memcached` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Memory | typing.Literal["memory"],
        /,
        *,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `memory` service.

        Parameters
        ----------
        root : builtins.str, optional
            root of the backend.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `memory` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.MiniMoka | typing.Literal["mini-moka"],
        /,
        *,
        max_capacity: builtins.int = ...,
        root: builtins.str = ...,
        time_to_idle: builtins.str = ...,
        time_to_live: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `mini-moka` service.

        Parameters
        ----------
        max_capacity : builtins.int, optional
            Sets the max capacity of the cache.
            Refer to
            [`mini-moka::sync::CacheBuilder::max_capacity`](https://docs.rs/mini-moka/latest/mini_moka/sync/struct.CacheBuilder.html#method.max_capacity)
        root : builtins.str, optional
            root path of this backend
        time_to_idle : builtins.str, optional
            Sets the time to idle of the cache.
            Refer to
            [`mini-moka::sync::CacheBuilder::time_to_idle`](https://docs.rs/mini-moka/latest/mini_moka/sync/struct.CacheBuilder.html#method.time_to_idle)
        time_to_live : builtins.str, optional
            Sets the time to live of the cache.
            Refer to
            [`mini-moka::sync::CacheBuilder::time_to_live`](https://docs.rs/mini-moka/latest/mini_moka/sync/struct.CacheBuilder.html#method.time_to_live)

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `mini-moka` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Moka | typing.Literal["moka"],
        /,
        *,
        max_capacity: builtins.int = ...,
        name: builtins.str = ...,
        root: builtins.str = ...,
        time_to_idle: builtins.str = ...,
        time_to_live: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `moka` service.

        Parameters
        ----------
        max_capacity : builtins.int, optional
            Sets the max capacity of the cache.
            Refer to
            [`moka::future::CacheBuilder::max_capacity`](https://docs.rs/moka/latest/moka/future/struct.CacheBuilder.html#method.max_capacity)
        name : builtins.str, optional
            Name for this cache instance.
        root : builtins.str, optional
            root path of this backend
        time_to_idle : builtins.str, optional
            Sets the time to idle of the cache.
            Refer to
            [`moka::future::CacheBuilder::time_to_idle`](https://docs.rs/moka/latest/moka/future/struct.CacheBuilder.html#method.time_to_idle)
        time_to_live : builtins.str, optional
            Sets the time to live of the cache.
            Refer to
            [`moka::future::CacheBuilder::time_to_live`](https://docs.rs/moka/latest/moka/future/struct.CacheBuilder.html#method.time_to_live)

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `moka` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Mongodb | typing.Literal["mongodb"],
        /,
        *,
        collection: builtins.str = ...,
        connection_string: builtins.str = ...,
        database: builtins.str = ...,
        key_field: builtins.str = ...,
        root: builtins.str = ...,
        value_field: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `mongodb` service.

        Parameters
        ----------
        collection : builtins.str, optional
            collection of this backend
        connection_string : builtins.str, optional
            connection string of this backend
        database : builtins.str, optional
            database of this backend
        key_field : builtins.str, optional
            key field of this backend
        root : builtins.str, optional
            root of this backend
        value_field : builtins.str, optional
            value field of this backend

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `mongodb` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Mysql | typing.Literal["mysql"],
        /,
        *,
        connection_string: builtins.str = ...,
        key_field: builtins.str = ...,
        root: builtins.str = ...,
        table: builtins.str = ...,
        value_field: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `mysql` service.

        Parameters
        ----------
        connection_string : builtins.str, optional
            This connection string is used to connect to the
            mysql service.
            There are url based formats.
            The format of connect string resembles the url
            format of the mysql client.
            The format is:
            `[scheme://][user[:[password]]@]host[:port][/schema][?attribute1=value1&attribute2=value2...`
            - `mysql://user@localhost` -
            `mysql://user:password@localhost` -
            `mysql://user:password@localhost:3306` -
            `mysql://user:password@localhost:3306/db` For more
            information, please refer to
            <https://docs.rs/sqlx/latest/sqlx/mysql/struct.MySqlConnectOptions.html>.
        key_field : builtins.str, optional
            The key field name for mysql.
        root : builtins.str, optional
            The root for mysql.
        table : builtins.str, optional
            The table name for mysql.
        value_field : builtins.str, optional
            The value field name for mysql.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `mysql` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Obs | typing.Literal["obs"],
        /,
        *,
        access_key_id: builtins.str = ...,
        bucket: builtins.str = ...,
        enable_versioning: builtins.bool = ...,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
        secret_access_key: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `obs` service.

        Parameters
        ----------
        access_key_id : builtins.str, optional
            Access key id for obs.
        bucket : builtins.str, optional
            Bucket for obs.
        enable_versioning : builtins.bool, optional
            Is bucket versioning enabled for this bucket
        endpoint : builtins.str, optional
            Endpoint for obs.
        root : builtins.str, optional
            Root for obs.
        secret_access_key : builtins.str, optional
            Secret access key for obs.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `obs` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Onedrive | typing.Literal["onedrive"],
        /,
        *,
        access_token: builtins.str = ...,
        client_id: builtins.str = ...,
        client_secret: builtins.str = ...,
        enable_versioning: builtins.bool = ...,
        refresh_token: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `onedrive` service.

        Parameters
        ----------
        access_token : builtins.str, optional
            Microsoft Graph API (also OneDrive API) access token
        client_id : builtins.str, optional
            Microsoft Graph API Application (client) ID that is
            in the Azure's app registration portal
        client_secret : builtins.str, optional
            Microsoft Graph API Application client secret that
            is in the Azure's app registration portal
        enable_versioning : builtins.bool, optional
            Enabling version support
        refresh_token : builtins.str, optional
            Microsoft Graph API (also OneDrive API) refresh
            token
        root : builtins.str, optional
            The root path for the OneDrive service for the file
            access

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `onedrive` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Oss | typing.Literal["oss"],
        /,
        *,
        access_key_id: builtins.str = ...,
        access_key_secret: builtins.str = ...,
        addressing_style: builtins.str = ...,
        allow_anonymous: builtins.bool = ...,
        batch_max_operations: builtins.int = ...,
        bucket: builtins.str,
        delete_max_size: builtins.int = ...,
        enable_versioning: builtins.bool = ...,
        endpoint: builtins.str = ...,
        oidc_provider_arn: builtins.str = ...,
        oidc_token_file: builtins.str = ...,
        presign_addressing_style: builtins.str = ...,
        presign_endpoint: builtins.str = ...,
        role_arn: builtins.str = ...,
        role_session_name: builtins.str = ...,
        root: builtins.str = ...,
        security_token: builtins.str = ...,
        server_side_encryption: builtins.str = ...,
        server_side_encryption_key_id: builtins.str = ...,
        sts_endpoint: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `oss` service.

        Parameters
        ----------
        access_key_id : builtins.str, optional
            Access key id for oss.
            - this field if it's `is_some` - env value:
            [`ALIBABA_CLOUD_ACCESS_KEY_ID`]
        access_key_secret : builtins.str, optional
            Access key secret for oss.
            - this field if it's `is_some` - env value:
            [`ALIBABA_CLOUD_ACCESS_KEY_SECRET`]
        addressing_style : builtins.str, optional
            Addressing style for oss.
        allow_anonymous : builtins.bool, optional
            Allow anonymous for oss.
        batch_max_operations : builtins.int, optional
            The size of max batch operations.
        bucket : builtins.str
            Bucket for oss.
        delete_max_size : builtins.int, optional
            The size of max delete operations.
        enable_versioning : builtins.bool, optional
            is bucket versioning enabled for this bucket
        endpoint : builtins.str, optional
            Endpoint for oss.
        oidc_provider_arn : builtins.str, optional
            `oidc_provider_arn` will be loaded from - this field
            if it's `is_some` - env value:
            [`ALIBABA_CLOUD_OIDC_PROVIDER_ARN`]
        oidc_token_file : builtins.str, optional
            `oidc_token_file` will be loaded from - this field
            if it's `is_some` - env value:
            [`ALIBABA_CLOUD_OIDC_TOKEN_FILE`]
        presign_addressing_style : builtins.str, optional
            Pre sign addressing style for oss.
        presign_endpoint : builtins.str, optional
            Presign endpoint for oss.
        role_arn : builtins.str, optional
            If `role_arn` is set, we will use already known
            config as source credential to assume role with
            `role_arn`.
            - this field if it's `is_some` - env value:
            [`ALIBABA_CLOUD_ROLE_ARN`]
        role_session_name : builtins.str, optional
            role_session_name for this backend.
        root : builtins.str, optional
            Root for oss.
        security_token : builtins.str, optional
            `security_token` will be loaded from - this field if
            it's `is_some` - env value:
            [`ALIBABA_CLOUD_SECURITY_TOKEN`]
        server_side_encryption : builtins.str, optional
            Server side encryption for oss.
        server_side_encryption_key_id : builtins.str, optional
            Server side encryption key id for oss.
        sts_endpoint : builtins.str, optional
            `sts_endpoint` will be loaded from - this field if
            it's `is_some` - env value:
            [`ALIBABA_CLOUD_STS_ENDPOINT`]

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `oss` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Persy | typing.Literal["persy"],
        /,
        *,
        datafile: builtins.str = ...,
        index: builtins.str = ...,
        segment: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `persy` service.

        Parameters
        ----------
        datafile : builtins.str, optional
            That path to the persy data file.
            The directory in the path must already exist.
        index : builtins.str, optional
            That name of the persy index.
        segment : builtins.str, optional
            That name of the persy segment.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `persy` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Postgresql | typing.Literal["postgresql"],
        /,
        *,
        connection_string: builtins.str = ...,
        key_field: builtins.str = ...,
        root: builtins.str = ...,
        table: builtins.str = ...,
        value_field: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `postgresql` service.

        Parameters
        ----------
        connection_string : builtins.str, optional
            The URL should be with a scheme of either
            `postgres://` or `postgresql://`.
            - `postgresql://user@localhost` -
            `postgresql://user:password@%2Fvar%2Flib%2Fpostgresql/mydb?connect_timeout=10`
            -
            `postgresql://user@host1:1234,host2,host3:5678?target_session_attrs=read-write`
            -
            `postgresql:///mydb?user=user&host=/var/lib/postgresql`
            For more information, please visit
            <https://docs.rs/sqlx/latest/sqlx/postgres/struct.PgConnectOptions.html>.
        key_field : builtins.str, optional
            the key field of postgresql
        root : builtins.str, optional
            Root of this backend.
            All operations will happen under this root.
            Default to `/` if not set.
        table : builtins.str, optional
            the table of postgresql
        value_field : builtins.str, optional
            the value field of postgresql

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `postgresql` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Redb | typing.Literal["redb"],
        /,
        *,
        datadir: builtins.str = ...,
        root: builtins.str = ...,
        table: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `redb` service.

        Parameters
        ----------
        datadir : builtins.str, optional
            path to the redb data directory.
        root : builtins.str, optional
            The root for redb.
        table : builtins.str, optional
            The table name for redb.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `redb` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Redis | typing.Literal["redis"],
        /,
        *,
        cluster_endpoints: builtins.str = ...,
        connection_pool_max_size: builtins.int = ...,
        db: builtins.int,
        default_ttl: typing.Any = ...,
        endpoint: builtins.str = ...,
        password: builtins.str = ...,
        root: builtins.str = ...,
        username: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `redis` service.

        Parameters
        ----------
        cluster_endpoints : builtins.str, optional
            network address of the Redis cluster service.
            Can be
            "tcp://127.0.0.1:6379,tcp://127.0.0.1:6380,tcp://127.0.0.1:6381",
            e.g.
            default is None
        connection_pool_max_size : builtins.int, optional
            The maximum number of connections allowed.
            default is 10
        db : builtins.int
            the number of DBs redis can take is unlimited
            default is db 0
        default_ttl : typing.Any, optional
            The default ttl for put operations..
            a human readable duration string see
            https://docs.rs/humantime/latest/humantime/fn.parse_duration.html
            for more details
        endpoint : builtins.str, optional
            network address of the Redis service.
            Can be "tcp://127.0.0.1:6379", e.g.
            default is "tcp://127.0.0.1:6379"
        password : builtins.str, optional
            the password for authentication default is None
        root : builtins.str, optional
            the working directory of the Redis service.
            Can be "/path/to/dir" default is "/"
        username : builtins.str, optional
            the username to connect redis service.
            default is None

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `redis` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.S3 | typing.Literal["s3"],
        /,
        *,
        access_key_id: builtins.str = ...,
        allow_anonymous: builtins.bool = ...,
        batch_max_operations: builtins.int = ...,
        bucket: builtins.str,
        checksum_algorithm: builtins.str = ...,
        default_storage_class: builtins.str = ...,
        delete_max_size: builtins.int = ...,
        disable_config_load: builtins.bool = ...,
        disable_ec2_metadata: builtins.bool = ...,
        disable_list_objects_v2: builtins.bool = ...,
        disable_stat_with_override: builtins.bool = ...,
        disable_write_with_if_match: builtins.bool = ...,
        enable_request_payer: builtins.bool = ...,
        enable_versioning: builtins.bool = ...,
        enable_virtual_host_style: builtins.bool = ...,
        enable_write_with_append: builtins.bool = ...,
        endpoint: builtins.str = ...,
        external_id: builtins.str = ...,
        region: builtins.str = ...,
        role_arn: builtins.str = ...,
        role_session_name: builtins.str = ...,
        root: builtins.str = ...,
        secret_access_key: builtins.str = ...,
        server_side_encryption: builtins.str = ...,
        server_side_encryption_aws_kms_key_id: builtins.str = ...,
        server_side_encryption_customer_algorithm: builtins.str = ...,
        server_side_encryption_customer_key: builtins.str = ...,
        server_side_encryption_customer_key_md5: builtins.str = ...,
        session_token: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `s3` service.

        Parameters
        ----------
        access_key_id : builtins.str, optional
            access_key_id of this backend.
            - If access_key_id is set, we will take user's input
            first.
            - If not, we will try to load it from environment.
        allow_anonymous : builtins.bool, optional
            Allow anonymous will allow opendal to send request
            without signing when credential is not loaded.
        batch_max_operations : builtins.int, optional
            Set maximum batch operations of this backend.
            Some compatible services have a limit on the number
            of operations in a batch request.
            For example, R2 could return `Internal Error` while
            batch delete 1000 files.
            Please tune this value based on services' document.
        bucket : builtins.str
            bucket name of this backend.
            required.
        checksum_algorithm : builtins.str, optional
            Checksum Algorithm to use when sending checksums in
            HTTP headers.
            This is necessary when writing to AWS S3 Buckets
            with Object Lock enabled for example.
            Available options: - "crc32c"
        default_storage_class : builtins.str, optional
            default storage_class for this backend.
            Available values: - `DEEP_ARCHIVE` - `GLACIER` -
            `GLACIER_IR` - `INTELLIGENT_TIERING` - `ONEZONE_IA`
            - `EXPRESS_ONEZONE` - `OUTPOSTS` -
            `REDUCED_REDUNDANCY` - `STANDARD` - `STANDARD_IA` S3
            compatible services don't support all of them
        delete_max_size : builtins.int, optional
            Set the maximum delete size of this backend.
            Some compatible services have a limit on the number
            of operations in a batch request.
            For example, R2 could return `Internal Error` while
            batch delete 1000 files.
            Please tune this value based on services' document.
        disable_config_load : builtins.bool, optional
            Disable config load so that opendal will not load
            config from environment.
            For examples: - envs like `AWS_ACCESS_KEY_ID` -
            files like `~/.aws/config`
        disable_ec2_metadata : builtins.bool, optional
            Disable load credential from ec2 metadata.
            This option is used to disable the default behavior
            of opendal to load credential from ec2 metadata,
            a.k.a, IMDSv2
        disable_list_objects_v2 : builtins.bool, optional
            OpenDAL uses List Objects V2 by default to list
            objects.
            However, some legacy services do not yet support V2.
            This option allows users to switch back to the older
            List Objects V1.
        disable_stat_with_override : builtins.bool, optional
            Disable stat with override so that opendal will not
            send stat request with override queries.
            For example, R2 doesn't support stat with
            `response_content_type` query.
        disable_write_with_if_match : builtins.bool, optional
            Disable write with if match so that opendal will not
            send write request with if match headers.
            For example, Ceph RADOS S3 doesn't support write
            with if match.
        enable_request_payer : builtins.bool, optional
            Indicates whether the client agrees to pay for the
            requests made to the S3 bucket.
        enable_versioning : builtins.bool, optional
            is bucket versioning enabled for this bucket
        enable_virtual_host_style : builtins.bool, optional
            Enable virtual host style so that opendal will send
            API requests in virtual host style instead of path
            style.
            - By default, opendal will send API to
            `https://s3.us-east-1.amazonaws.com/bucket_name` -
            Enabled, opendal will send API to
            `https://bucket_name.s3.us-east-1.amazonaws.com`
        enable_write_with_append : builtins.bool, optional
            Enable write with append so that opendal will send
            write request with append headers.
        endpoint : builtins.str, optional
            endpoint of this backend.
            Endpoint must be full uri, e.g.
            - AWS S3: `https://s3.amazonaws.com` or
            `https://s3.{region}.amazonaws.com` - Cloudflare R2:
            `https://<ACCOUNT_ID>.r2.cloudflarestorage.com` -
            Aliyun OSS: `https://{region}.aliyuncs.com` -
            Tencent COS: `https://cos.{region}.myqcloud.com` -
            Minio: `http://127.0.0.1:9000` If user inputs
            endpoint without scheme like "s3.amazonaws.com", we
            will prepend "https://" before it.
            - If endpoint is set, we will take user's input
            first.
            - If not, we will try to load it from environment.
            - If still not set, default to
            `https://s3.amazonaws.com`.
        external_id : builtins.str, optional
            external_id for this backend.
        region : builtins.str, optional
            Region represent the signing region of this
            endpoint.
            This is required if you are using the default AWS S3
            endpoint.
            If using a custom endpoint, - If region is set, we
            will take user's input first.
            - If not, we will try to load it from environment.
        role_arn : builtins.str, optional
            role_arn for this backend.
            If `role_arn` is set, we will use already known
            config as source credential to assume role with
            `role_arn`.
        role_session_name : builtins.str, optional
            role_session_name for this backend.
        root : builtins.str, optional
            root of this backend.
            All operations will happen under this root.
            default to `/` if not set.
        secret_access_key : builtins.str, optional
            secret_access_key of this backend.
            - If secret_access_key is set, we will take user's
            input first.
            - If not, we will try to load it from environment.
        server_side_encryption : builtins.str, optional
            server_side_encryption for this backend.
            Available values: `AES256`, `aws:kms`.
        server_side_encryption_aws_kms_key_id : builtins.str, optional
            server_side_encryption_aws_kms_key_id for this
            backend - If `server_side_encryption` set to
            `aws:kms`, and
            `server_side_encryption_aws_kms_key_id` is not set,
            S3 will use aws managed kms key to encrypt data.
            - If `server_side_encryption` set to `aws:kms`, and
            `server_side_encryption_aws_kms_key_id` is a valid
            kms key id, S3 will use the provided kms key to
            encrypt data.
            - If the `server_side_encryption_aws_kms_key_id` is
            invalid or not found, an error will be returned.
            - If `server_side_encryption` is not `aws:kms`,
            setting `server_side_encryption_aws_kms_key_id` is a
            noop.
        server_side_encryption_customer_algorithm : builtins.str, optional
            server_side_encryption_customer_algorithm for this
            backend.
            Available values: `AES256`.
        server_side_encryption_customer_key : builtins.str, optional
            server_side_encryption_customer_key for this
            backend.
            Value: BASE64-encoded key that matches algorithm
            specified in
            `server_side_encryption_customer_algorithm`.
        server_side_encryption_customer_key_md5 : builtins.str, optional
            Set server_side_encryption_customer_key_md5 for this
            backend.
            Value: MD5 digest of key specified in
            `server_side_encryption_customer_key`.
        session_token : builtins.str, optional
            session_token (aka, security token) of this backend.
            This token will expire after sometime, it's
            recommended to set session_token by hand.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `s3` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Seafile | typing.Literal["seafile"],
        /,
        *,
        endpoint: builtins.str = ...,
        password: builtins.str = ...,
        repo_name: builtins.str,
        root: builtins.str = ...,
        username: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `seafile` service.

        Parameters
        ----------
        endpoint : builtins.str, optional
            endpoint address of this backend.
        password : builtins.str, optional
            password of this backend.
        repo_name : builtins.str
            repo_name of this backend.
            required.
        root : builtins.str, optional
            root of this backend.
            All operations will happen under this root.
        username : builtins.str, optional
            username of this backend.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `seafile` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Sftp | typing.Literal["sftp"],
        /,
        *,
        enable_copy: builtins.bool = ...,
        endpoint: builtins.str = ...,
        key: builtins.str = ...,
        known_hosts_strategy: builtins.str = ...,
        root: builtins.str = ...,
        user: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `sftp` service.

        Parameters
        ----------
        enable_copy : builtins.bool, optional
            enable_copy of this backend
        endpoint : builtins.str, optional
            endpoint of this backend
        key : builtins.str, optional
            key of this backend
        known_hosts_strategy : builtins.str, optional
            known_hosts_strategy of this backend
        root : builtins.str, optional
            root of this backend
        user : builtins.str, optional
            user of this backend

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `sftp` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Sled | typing.Literal["sled"],
        /,
        *,
        datadir: builtins.str = ...,
        root: builtins.str = ...,
        tree: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `sled` service.

        Parameters
        ----------
        datadir : builtins.str, optional
            That path to the sled data directory.
        root : builtins.str, optional
            The root for sled.
        tree : builtins.str, optional
            The tree for sled.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `sled` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Sqlite | typing.Literal["sqlite"],
        /,
        *,
        connection_string: builtins.str = ...,
        key_field: builtins.str = ...,
        root: builtins.str = ...,
        table: builtins.str = ...,
        value_field: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `sqlite` service.

        Parameters
        ----------
        connection_string : builtins.str, optional
            Set the connection_string of the sqlite service.
            This connection string is used to connect to the
            sqlite service.
            The format of connect string resembles the url
            format of the sqlite client: - `sqlite::memory:` -
            `sqlite:data.db` - `sqlite://data.db` For more
            information, please visit
            <https://docs.rs/sqlx/latest/sqlx/sqlite/struct.SqliteConnectOptions.html>.
        key_field : builtins.str, optional
            Set the key field name of the sqlite service to
            read/write.
            Default to `key` if not specified.
        root : builtins.str, optional
            set the working directory, all operations will be
            performed under it.
            default: "/"
        table : builtins.str, optional
            Set the table name of the sqlite service to
            read/write.
        value_field : builtins.str, optional
            Set the value field name of the sqlite service to
            read/write.
            Default to `value` if not specified.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `sqlite` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Swift | typing.Literal["swift"],
        /,
        *,
        container: builtins.str = ...,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
        token: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `swift` service.

        Parameters
        ----------
        container : builtins.str, optional
            The container for Swift.
        endpoint : builtins.str, optional
            The endpoint for Swift.
        root : builtins.str, optional
            The root for Swift.
        token : builtins.str, optional
            The token for Swift.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `swift` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Upyun | typing.Literal["upyun"],
        /,
        *,
        bucket: builtins.str,
        operator: builtins.str = ...,
        password: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `upyun` service.

        Parameters
        ----------
        bucket : builtins.str
            bucket address of this backend.
        operator : builtins.str, optional
            username of this backend.
        password : builtins.str, optional
            password of this backend.
        root : builtins.str, optional
            root of this backend.
            All operations will happen under this root.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `upyun` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.VercelArtifacts
        | typing.Literal["vercel-artifacts"],
        /,
        *,
        access_token: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `vercel-artifacts` service.

        Parameters
        ----------
        access_token : builtins.str, optional
            The access token for Vercel.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `vercel-artifacts` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Webdav | typing.Literal["webdav"],
        /,
        *,
        disable_copy: builtins.bool = ...,
        endpoint: builtins.str = ...,
        password: builtins.str = ...,
        root: builtins.str = ...,
        token: builtins.str = ...,
        username: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `webdav` service.

        Parameters
        ----------
        disable_copy : builtins.bool, optional
            WebDAV Service doesn't support copy.
        endpoint : builtins.str, optional
            endpoint of this backend
        password : builtins.str, optional
            password of this backend
        root : builtins.str, optional
            root of this backend
        token : builtins.str, optional
            token of this backend
        username : builtins.str, optional
            username of this backend

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `webdav` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Webhdfs | typing.Literal["webhdfs"],
        /,
        *,
        atomic_write_dir: builtins.str = ...,
        delegation: builtins.str = ...,
        disable_list_batch: builtins.bool = ...,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
        user_name: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `webhdfs` service.

        Parameters
        ----------
        atomic_write_dir : builtins.str, optional
            atomic_write_dir of this backend
        delegation : builtins.str, optional
            Delegation token for webhdfs.
        disable_list_batch : builtins.bool, optional
            Disable batch listing
        endpoint : builtins.str, optional
            Endpoint for webhdfs.
        root : builtins.str, optional
            Root for webhdfs.
        user_name : builtins.str, optional
            Name of the user for webhdfs.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `webhdfs` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.YandexDisk | typing.Literal["yandex-disk"],
        /,
        *,
        access_token: builtins.str,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `AsyncOperator` for `yandex-disk` service.

        Parameters
        ----------
        access_token : builtins.str
            yandex disk oauth access_token.
        root : builtins.str, optional
            root of this backend.
            All operations will happen under this root.

        Returns
        -------
        AsyncOperator
            The new `AsyncOperator` for `yandex-disk` service
        """

@typing.final
class Operator:
    r"""
    The blocking equivalent of `AsyncOperator`.

    `Operator` is the entry point for all blocking APIs.

    See Also
    --------
    AsyncOperator
    """

    def layer(self, layer: Layer) -> Operator:
        r"""
        Add a new layer to this operator.

        Parameters
        ----------
        layer : Layer
            The layer to add.

        Returns
        -------
        Operator
            A new operator with the layer added.
        """
    def open(
        self,
        path: builtins.str | os.PathLike | pathlib.Path,
        mode: builtins.str,
        **kwargs: typing.Any,
    ) -> File:
        r"""
        Open a file-like object for the given path.

        The returning file-like object is a context manager.

        Parameters
        ----------
        path : str
            The path to the file.
        mode : str
            The mode to open the file in. Only "rb" and "wb" are supported.
        **kwargs
            Additional options for the underlying reader or writer.

        Returns
        -------
        File
            A file-like object.
        """
    def read(
        self,
        path: builtins.str | os.PathLike | pathlib.Path,
        *,
        version: builtins.str | None = None,
        concurrent: builtins.int | None = None,
        chunk: builtins.int | None = None,
        gap: builtins.int | None = None,
        offset: builtins.int | None = None,
        prefetch: builtins.int | None = None,
        size: builtins.int | None = None,
        if_match: builtins.str | None = None,
        if_none_match: builtins.str | None = None,
        if_modified_since: datetime.datetime = None,
        if_unmodified_since: datetime.datetime = None,
        content_type: builtins.str | None = None,
        cache_control: builtins.str | None = None,
        content_disposition: builtins.str | None = None,
    ) -> builtins.bytes:
        r"""
        Read the entire contents of a file at the given path.

        Parameters
        ----------
        path : str
            The path to the file.
        version : str, optional
            The version of the file.
        concurrent : int, optional
            The number of concurrent readers.
        chunk : int, optional
            The size of each chunk.
        gap : int, optional
            The gap between each chunk.
        offset : int, optional
            The offset of the file.
        prefetch : int, optional
            The number of bytes to prefetch.
        size : int, optional
            The size of the file.
        if_match : str, optional
            The ETag of the file.
        if_none_match : str, optional
            The ETag of the file.
        if_modified_since : str, optional
            The last modified time of the file.
        if_unmodified_since : str, optional
            The last modified time of the file.
        content_type : str, optional
            The content type of the file.
        cache_control : str, optional
            The cache control of the file.
        content_disposition : str, optional
            The content disposition of the file.

        Returns
        -------
        bytes
            The contents of the file as bytes.
        """
    def write(
        self,
        path: builtins.str | os.PathLike | pathlib.Path,
        bs: builtins.bytes,
        *,
        append: builtins.bool | None = None,
        chunk: builtins.int | None = None,
        concurrent: builtins.int | None = None,
        cache_control: builtins.str | None = None,
        content_type: builtins.str | None = None,
        content_disposition: builtins.str | None = None,
        content_encoding: builtins.str | None = None,
        if_match: builtins.str | None = None,
        if_none_match: builtins.str | None = None,
        if_not_exists: builtins.bool | None = None,
        user_metadata: typing.Mapping[builtins.str, builtins.str] | None = None,
    ) -> None:
        r"""
        Write bytes to a file at the given path.

        This function will create a file if it does not exist, and will
        overwrite its contents if it does.

        Parameters
        ----------
        path : str
            The path to the file.
        bs : bytes
            The contents to write to the file.
        append : bool, optional
            Whether to append to the file instead of overwriting it.
        chunk : int, optional
            The chunk size to use when writing the file.
        concurrent : int, optional
            The number of concurrent requests to make when writing the file.
        cache_control : str, optional
            The cache control header to set on the file.
        content_type : str, optional
            The content type header to set on the file.
        content_disposition : str, optional
            The content disposition header to set on the file.
        content_encoding : str, optional
            The content encoding header to set on the file.
        if_match : str, optional
            The ETag to match when writing the file.
        if_none_match : str, optional
            The ETag to not match when writing the file.
        if_not_exists : bool, optional
            Whether to fail if the file already exists.
        user_metadata : dict, optional
            The user metadata to set on the file.
        """
    def stat(
        self,
        path: builtins.str | os.PathLike | pathlib.Path,
        *,
        version: builtins.str | None = None,
        if_match: builtins.str | None = None,
        if_none_match: builtins.str | None = None,
        if_modified_since: datetime.datetime = None,
        if_unmodified_since: datetime.datetime = None,
        content_type: builtins.str | None = None,
        cache_control: builtins.str | None = None,
        content_disposition: builtins.str | None = None,
    ) -> Metadata:
        r"""
        Get the metadata of a file at the given path.

        Parameters
        ----------
        path : str
            The path to the file.
        version : str, optional
            The version of the file.
        if_match : str, optional
            The ETag of the file.
        if_none_match : str, optional
            The ETag of the file.
        if_modified_since : datetime, optional
            The last modified time of the file.
        if_unmodified_since : datetime, optional
            The last modified time of the file.
        content_type : str, optional
            The content type of the file.
        cache_control : str, optional
            The cache control of the file.
        content_disposition : str, optional
            The content disposition of the file.

        Returns
        -------
        Metadata
            The metadata of the file.
        """
    def copy(
        self,
        source: builtins.str | os.PathLike | pathlib.Path,
        target: builtins.str | os.PathLike | pathlib.Path,
    ) -> None:
        r"""
        Copy a file from one path to another.

        Parameters
        ----------
        source : str
            The path to the source file.
        target : str
            The path to the target file.
        """
    def rename(
        self,
        source: builtins.str | os.PathLike | pathlib.Path,
        target: builtins.str | os.PathLike | pathlib.Path,
    ) -> None:
        r"""
        Rename (move) a file from one path to another.

        Parameters
        ----------
        source : str
            The path to the source file.
        target : str
            The path to the target file.
        """
    def remove_all(self, path: builtins.str | os.PathLike | pathlib.Path) -> None:
        r"""
        Recursively remove all files and directories at the given path.

        Parameters
        ----------
        path : str
            The path to remove.
        """
    def create_dir(self, path: builtins.str | os.PathLike | pathlib.Path) -> None:
        r"""
        Create a directory at the given path.

        Notes
        -----
        To indicate that a path is a directory, it must end with a `/`.
        This operation is always recursive, like `mkdir -p`.

        Parameters
        ----------
        path : str
            The path to the directory.
        """
    def delete(self, path: builtins.str | os.PathLike | pathlib.Path) -> None:
        r"""
        Delete a file at the given path.

        Notes
        -----
        This operation will not return an error if the path does not exist.

        Parameters
        ----------
        path : str
            The path to the file.
        """
    def exists(self, path: builtins.str | os.PathLike | pathlib.Path) -> builtins.bool:
        r"""
        Check if a path exists.

        Parameters
        ----------
        path : str
            The path to check.

        Returns
        -------
        bool
            True if the path exists, False otherwise.
        """
    def list(
        self,
        path: builtins.str | os.PathLike | pathlib.Path,
        *,
        limit: builtins.int | None = None,
        start_after: builtins.str | None = None,
        recursive: builtins.bool | None = None,
        versions: builtins.bool | None = None,
        deleted: builtins.bool | None = None,
    ) -> collections.abc.Iterable[opendal.types.Entry]:
        r"""
        List entries in the given directory.

        Parameters
        ----------
        path : str
            The path to the directory.
        limit : int, optional
            The maximum number of entries to return.
        start_after : str, optional
            The entry to start after.
        recursive : bool, optional
            Whether to list recursively.
        versions : bool, optional
            Whether to list versions.
        deleted : bool, optional
            Whether to list deleted entries.

        Returns
        -------
        BlockingLister
            An iterator over the entries in the directory.
        """
    def scan(
        self,
        path: builtins.str | os.PathLike | pathlib.Path,
        *,
        limit: builtins.int | None = None,
        start_after: builtins.str | None = None,
        versions: builtins.bool | None = None,
        deleted: builtins.bool | None = None,
    ) -> collections.abc.Iterable[opendal.types.Entry]:
        r"""
        Recursively list entries in the given directory.

        Deprecated
        ----------
            Use `list()` with `recursive=True` instead.

        Parameters
        ----------
        path : str
            The path to the directory.
        limit : int, optional
            The maximum number of entries to return.
        start_after : str, optional
            The entry to start after.
        versions : bool, optional
            Whether to list versions.
        deleted : bool, optional
            Whether to list deleted entries.

        Returns
        -------
        BlockingLister
            An iterator over the entries in the directory.
        """
    def capability(self) -> Capability:
        r"""
        Get all capabilities of this operator.

        Returns
        -------
        Capability
            The capability of the operator.
        """
    def check(self) -> None:
        r"""
        Check if the operator is able to work correctly.

        Raises
        ------
        Exception
            If the operator is not able to work correctly.
        """
    def to_async_operator(self) -> AsyncOperator:
        r"""
        Create a new `AsyncOperator` from this blocking operator.

        Returns
        -------
        AsyncOperator
            The async operator.
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.AliyunDrive | typing.Literal["aliyun-drive"],
        /,
        *,
        access_token: builtins.str = ...,
        client_id: builtins.str = ...,
        client_secret: builtins.str = ...,
        drive_type: builtins.str,
        refresh_token: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `aliyun-drive` service.

        Parameters
        ----------
        access_token : builtins.str, optional
            The access_token of this backend.
            Solution for client-only purpose.
            #4733 Required if no client_id, client_secret and
            refresh_token are provided.
        client_id : builtins.str, optional
            The client_id of this backend.
            Required if no access_token is provided.
        client_secret : builtins.str, optional
            The client_secret of this backend.
            Required if no access_token is provided.
        drive_type : builtins.str
            The drive_type of this backend.
            All operations will happen under this type of drive.
            Available values are `default`, `backup` and
            `resource`.
            Fallback to default if not set or no other drives
            can be found.
        refresh_token : builtins.str, optional
            The refresh_token of this backend.
            Required if no access_token is provided.
        root : builtins.str, optional
            The Root of this backend.
            All operations will happen under this root.
            Default to `/` if not set.

        Returns
        -------
        Operator
            The new `Operator` for `aliyun-drive` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Alluxio | typing.Literal["alluxio"],
        /,
        *,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `alluxio` service.

        Parameters
        ----------
        endpoint : builtins.str, optional
            endpoint of this backend.
            Endpoint must be full uri, mostly like
            `http://127.0.0.1:39999`.
        root : builtins.str, optional
            root of this backend.
            All operations will happen under this root.
            default to `/` if not set.

        Returns
        -------
        Operator
            The new `Operator` for `alluxio` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Azblob | typing.Literal["azblob"],
        /,
        *,
        account_key: builtins.str = ...,
        account_name: builtins.str = ...,
        batch_max_operations: builtins.int = ...,
        container: builtins.str,
        encryption_algorithm: builtins.str = ...,
        encryption_key: builtins.str = ...,
        encryption_key_sha256: builtins.str = ...,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
        sas_token: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `azblob` service.

        Parameters
        ----------
        account_key : builtins.str, optional
            The account key of Azblob service backend.
        account_name : builtins.str, optional
            The account name of Azblob service backend.
        batch_max_operations : builtins.int, optional
            The maximum batch operations of Azblob service
            backend.
        container : builtins.str
            The container name of Azblob service backend.
        encryption_algorithm : builtins.str, optional
            The encryption algorithm of Azblob service backend.
        encryption_key : builtins.str, optional
            The encryption key of Azblob service backend.
        encryption_key_sha256 : builtins.str, optional
            The encryption key sha256 of Azblob service backend.
        endpoint : builtins.str, optional
            The endpoint of Azblob service backend.
            Endpoint must be full uri, e.g.
            - Azblob:
            `https://accountname.blob.core.windows.net` -
            Azurite: `http://127.0.0.1:10000/devstoreaccount1`
        root : builtins.str, optional
            The root of Azblob service backend.
            All operations will happen under this root.
        sas_token : builtins.str, optional
            The sas token of Azblob service backend.

        Returns
        -------
        Operator
            The new `Operator` for `azblob` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Azdls | typing.Literal["azdls"],
        /,
        *,
        account_key: builtins.str = ...,
        account_name: builtins.str = ...,
        authority_host: builtins.str = ...,
        client_id: builtins.str = ...,
        client_secret: builtins.str = ...,
        endpoint: builtins.str = ...,
        filesystem: builtins.str,
        root: builtins.str = ...,
        sas_token: builtins.str = ...,
        tenant_id: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `azdls` service.

        Parameters
        ----------
        account_key : builtins.str, optional
            Account key of this backend.
            - required for shared_key authentication
        account_name : builtins.str, optional
            Account name of this backend.
        authority_host : builtins.str, optional
            authority_host The authority host of the service
            principal.
            - required for client_credentials authentication -
            default value: `https://login.microsoftonline.com`
        client_id : builtins.str, optional
            client_id The client id of the service principal.
            - required for client_credentials authentication
        client_secret : builtins.str, optional
            client_secret The client secret of the service
            principal.
            - required for client_credentials authentication
        endpoint : builtins.str, optional
            Endpoint of this backend.
        filesystem : builtins.str
            Filesystem name of this backend.
        root : builtins.str, optional
            Root of this backend.
        sas_token : builtins.str, optional
            sas_token The shared access signature token.
            - required for sas authentication
        tenant_id : builtins.str, optional
            tenant_id The tenant id of the service principal.
            - required for client_credentials authentication

        Returns
        -------
        Operator
            The new `Operator` for `azdls` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Azfile | typing.Literal["azfile"],
        /,
        *,
        account_key: builtins.str = ...,
        account_name: builtins.str = ...,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
        sas_token: builtins.str = ...,
        share_name: builtins.str,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `azfile` service.

        Parameters
        ----------
        account_key : builtins.str, optional
            The account key for azfile.
        account_name : builtins.str, optional
            The account name for azfile.
        endpoint : builtins.str, optional
            The endpoint for azfile.
        root : builtins.str, optional
            The root path for azfile.
        sas_token : builtins.str, optional
            The sas token for azfile.
        share_name : builtins.str
            The share name for azfile.

        Returns
        -------
        Operator
            The new `Operator` for `azfile` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.B2 | typing.Literal["b2"],
        /,
        *,
        application_key: builtins.str = ...,
        application_key_id: builtins.str = ...,
        bucket: builtins.str,
        bucket_id: builtins.str,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `b2` service.

        Parameters
        ----------
        application_key : builtins.str, optional
            applicationKey of this backend.
            - If application_key is set, we will take user's
            input first.
            - If not, we will try to load it from environment.
        application_key_id : builtins.str, optional
            keyID of this backend.
            - If application_key_id is set, we will take user's
            input first.
            - If not, we will try to load it from environment.
        bucket : builtins.str
            bucket of this backend.
            required.
        bucket_id : builtins.str
            bucket id of this backend.
            required.
        root : builtins.str, optional
            root of this backend.
            All operations will happen under this root.

        Returns
        -------
        Operator
            The new `Operator` for `b2` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Cacache | typing.Literal["cacache"],
        /,
        *,
        datadir: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `cacache` service.

        Parameters
        ----------
        datadir : builtins.str, optional
            That path to the cacache data directory.

        Returns
        -------
        Operator
            The new `Operator` for `cacache` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Cos | typing.Literal["cos"],
        /,
        *,
        bucket: builtins.str = ...,
        disable_config_load: builtins.bool = ...,
        enable_versioning: builtins.bool = ...,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
        secret_id: builtins.str = ...,
        secret_key: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `cos` service.

        Parameters
        ----------
        bucket : builtins.str, optional
            Bucket of this backend.
        disable_config_load : builtins.bool, optional
            Disable config load so that opendal will not load
            config from
        enable_versioning : builtins.bool, optional
            is bucket versioning enabled for this bucket
        endpoint : builtins.str, optional
            Endpoint of this backend.
        root : builtins.str, optional
            Root of this backend.
        secret_id : builtins.str, optional
            Secret ID of this backend.
        secret_key : builtins.str, optional
            Secret key of this backend.

        Returns
        -------
        Operator
            The new `Operator` for `cos` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Dashmap | typing.Literal["dashmap"],
        /,
        *,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `dashmap` service.

        Parameters
        ----------
        root : builtins.str, optional
            root path of this backend

        Returns
        -------
        Operator
            The new `Operator` for `dashmap` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Dropbox | typing.Literal["dropbox"],
        /,
        *,
        access_token: builtins.str = ...,
        client_id: builtins.str = ...,
        client_secret: builtins.str = ...,
        refresh_token: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `dropbox` service.

        Parameters
        ----------
        access_token : builtins.str, optional
            access token for dropbox.
        client_id : builtins.str, optional
            client_id for dropbox.
        client_secret : builtins.str, optional
            client_secret for dropbox.
        refresh_token : builtins.str, optional
            refresh_token for dropbox.
        root : builtins.str, optional
            root path for dropbox.

        Returns
        -------
        Operator
            The new `Operator` for `dropbox` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Fs | typing.Literal["fs"],
        /,
        *,
        atomic_write_dir: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `fs` service.

        Parameters
        ----------
        atomic_write_dir : builtins.str, optional
            tmp dir for atomic write
        root : builtins.str, optional
            root dir for backend

        Returns
        -------
        Operator
            The new `Operator` for `fs` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Ftp | typing.Literal["ftp"],
        /,
        *,
        endpoint: builtins.str = ...,
        password: builtins.str = ...,
        root: builtins.str = ...,
        user: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `ftp` service.

        Parameters
        ----------
        endpoint : builtins.str, optional
            endpoint of this backend
        password : builtins.str, optional
            password of this backend
        root : builtins.str, optional
            root of this backend
        user : builtins.str, optional
            user of this backend

        Returns
        -------
        Operator
            The new `Operator` for `ftp` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Gcs | typing.Literal["gcs"],
        /,
        *,
        allow_anonymous: builtins.bool = ...,
        bucket: builtins.str,
        credential: builtins.str = ...,
        credential_path: builtins.str = ...,
        default_storage_class: builtins.str = ...,
        disable_config_load: builtins.bool = ...,
        disable_vm_metadata: builtins.bool = ...,
        endpoint: builtins.str = ...,
        predefined_acl: builtins.str = ...,
        root: builtins.str = ...,
        scope: builtins.str = ...,
        service_account: builtins.str = ...,
        token: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `gcs` service.

        Parameters
        ----------
        allow_anonymous : builtins.bool, optional
            Allow opendal to send requests without signing when
            credentials are not loaded.
        bucket : builtins.str
            bucket name
        credential : builtins.str, optional
            Credentials string for GCS service OAuth2
            authentication.
        credential_path : builtins.str, optional
            Local path to credentials file for GCS service
            OAuth2 authentication.
        default_storage_class : builtins.str, optional
            The default storage class used by gcs.
        disable_config_load : builtins.bool, optional
            Disable loading configuration from the environment.
        disable_vm_metadata : builtins.bool, optional
            Disable attempting to load credentials from the GCE
            metadata server when running within Google Cloud.
        endpoint : builtins.str, optional
            endpoint URI of GCS service, default is
            `https://storage.googleapis.com`
        predefined_acl : builtins.str, optional
            The predefined acl for GCS.
        root : builtins.str, optional
            root URI, all operations happens under `root`
        scope : builtins.str, optional
            Scope for gcs.
        service_account : builtins.str, optional
            Service Account for gcs.
        token : builtins.str, optional
            A Google Cloud OAuth2 token.
            Takes precedence over `credential` and
            `credential_path`.

        Returns
        -------
        Operator
            The new `Operator` for `gcs` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Gdrive | typing.Literal["gdrive"],
        /,
        *,
        access_token: builtins.str = ...,
        client_id: builtins.str = ...,
        client_secret: builtins.str = ...,
        refresh_token: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `gdrive` service.

        Parameters
        ----------
        access_token : builtins.str, optional
            Access token for gdrive.
        client_id : builtins.str, optional
            Client id for gdrive.
        client_secret : builtins.str, optional
            Client secret for gdrive.
        refresh_token : builtins.str, optional
            Refresh token for gdrive.
        root : builtins.str, optional
            The root for gdrive

        Returns
        -------
        Operator
            The new `Operator` for `gdrive` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Ghac | typing.Literal["ghac"],
        /,
        *,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
        runtime_token: builtins.str = ...,
        version: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `ghac` service.

        Parameters
        ----------
        endpoint : builtins.str, optional
            The endpoint for ghac service.
        root : builtins.str, optional
            The root path for ghac.
        runtime_token : builtins.str, optional
            The runtime token for ghac service.
        version : builtins.str, optional
            The version that used by cache.

        Returns
        -------
        Operator
            The new `Operator` for `ghac` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Gridfs | typing.Literal["gridfs"],
        /,
        *,
        bucket: builtins.str = ...,
        chunk_size: builtins.int = ...,
        connection_string: builtins.str = ...,
        database: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `gridfs` service.

        Parameters
        ----------
        bucket : builtins.str, optional
            The bucket name of the MongoDB GridFs service to
            read/write.
        chunk_size : builtins.int, optional
            The chunk size of the MongoDB GridFs service used to
            break the user file into chunks.
        connection_string : builtins.str, optional
            The connection string of the MongoDB service.
        database : builtins.str, optional
            The database name of the MongoDB GridFs service to
            read/write.
        root : builtins.str, optional
            The working directory, all operations will be
            performed under it.

        Returns
        -------
        Operator
            The new `Operator` for `gridfs` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.HdfsNative | typing.Literal["hdfs-native"],
        /,
        *,
        enable_append: builtins.bool = ...,
        name_node: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `hdfs-native` service.

        Parameters
        ----------
        enable_append : builtins.bool, optional
            enable the append capacity
        name_node : builtins.str, optional
            name_node of this backend
        root : builtins.str, optional
            work dir of this backend

        Returns
        -------
        Operator
            The new `Operator` for `hdfs-native` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Http | typing.Literal["http"],
        /,
        *,
        endpoint: builtins.str = ...,
        password: builtins.str = ...,
        root: builtins.str = ...,
        token: builtins.str = ...,
        username: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `http` service.

        Parameters
        ----------
        endpoint : builtins.str, optional
            endpoint of this backend
        password : builtins.str, optional
            password of this backend
        root : builtins.str, optional
            root of this backend
        token : builtins.str, optional
            token of this backend
        username : builtins.str, optional
            username of this backend

        Returns
        -------
        Operator
            The new `Operator` for `http` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Huggingface | typing.Literal["huggingface"],
        /,
        *,
        repo_id: builtins.str = ...,
        repo_type: builtins.str = ...,
        revision: builtins.str = ...,
        root: builtins.str = ...,
        token: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `huggingface` service.

        Parameters
        ----------
        repo_id : builtins.str, optional
            Repo id of this backend.
            This is required.
        repo_type : builtins.str, optional
            Repo type of this backend.
            Default is model.
            Available values: - model - dataset
        revision : builtins.str, optional
            Revision of this backend.
            Default is main.
        root : builtins.str, optional
            Root of this backend.
            Can be "/path/to/dir".
            Default is "/".
        token : builtins.str, optional
            Token of this backend.
            This is optional.

        Returns
        -------
        Operator
            The new `Operator` for `huggingface` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Ipfs | typing.Literal["ipfs"],
        /,
        *,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `ipfs` service.

        Parameters
        ----------
        endpoint : builtins.str, optional
            IPFS gateway endpoint.
        root : builtins.str, optional
            IPFS root.

        Returns
        -------
        Operator
            The new `Operator` for `ipfs` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Ipmfs | typing.Literal["ipmfs"],
        /,
        *,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `ipmfs` service.

        Parameters
        ----------
        endpoint : builtins.str, optional
            Endpoint for ipfs.
        root : builtins.str, optional
            Root for ipfs.

        Returns
        -------
        Operator
            The new `Operator` for `ipmfs` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Koofr | typing.Literal["koofr"],
        /,
        *,
        email: builtins.str,
        endpoint: builtins.str,
        password: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `koofr` service.

        Parameters
        ----------
        email : builtins.str
            Koofr email.
        endpoint : builtins.str
            Koofr endpoint.
        password : builtins.str, optional
            password of this backend.
            (Must be the application password)
        root : builtins.str, optional
            root of this backend.
            All operations will happen under this root.

        Returns
        -------
        Operator
            The new `Operator` for `koofr` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Memcached | typing.Literal["memcached"],
        /,
        *,
        connection_pool_max_size: builtins.int = ...,
        default_ttl: typing.Any = ...,
        endpoint: builtins.str = ...,
        password: builtins.str = ...,
        root: builtins.str = ...,
        username: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `memcached` service.

        Parameters
        ----------
        connection_pool_max_size : builtins.int, optional
            The maximum number of connections allowed.
            default is 10
        default_ttl : typing.Any, optional
            The default ttl for put operations..
            a human readable duration string see
            https://docs.rs/humantime/latest/humantime/fn.parse_duration.html
            for more details
        endpoint : builtins.str, optional
            network address of the memcached service.
            For example: "tcp://localhost:11211"
        password : builtins.str, optional
            Memcached password, optional.
        root : builtins.str, optional
            the working directory of the service.
            Can be "/path/to/dir" default is "/"
        username : builtins.str, optional
            Memcached username, optional.

        Returns
        -------
        Operator
            The new `Operator` for `memcached` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Memory | typing.Literal["memory"],
        /,
        *,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `memory` service.

        Parameters
        ----------
        root : builtins.str, optional
            root of the backend.

        Returns
        -------
        Operator
            The new `Operator` for `memory` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.MiniMoka | typing.Literal["mini-moka"],
        /,
        *,
        max_capacity: builtins.int = ...,
        root: builtins.str = ...,
        time_to_idle: builtins.str = ...,
        time_to_live: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `mini-moka` service.

        Parameters
        ----------
        max_capacity : builtins.int, optional
            Sets the max capacity of the cache.
            Refer to
            [`mini-moka::sync::CacheBuilder::max_capacity`](https://docs.rs/mini-moka/latest/mini_moka/sync/struct.CacheBuilder.html#method.max_capacity)
        root : builtins.str, optional
            root path of this backend
        time_to_idle : builtins.str, optional
            Sets the time to idle of the cache.
            Refer to
            [`mini-moka::sync::CacheBuilder::time_to_idle`](https://docs.rs/mini-moka/latest/mini_moka/sync/struct.CacheBuilder.html#method.time_to_idle)
        time_to_live : builtins.str, optional
            Sets the time to live of the cache.
            Refer to
            [`mini-moka::sync::CacheBuilder::time_to_live`](https://docs.rs/mini-moka/latest/mini_moka/sync/struct.CacheBuilder.html#method.time_to_live)

        Returns
        -------
        Operator
            The new `Operator` for `mini-moka` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Moka | typing.Literal["moka"],
        /,
        *,
        max_capacity: builtins.int = ...,
        name: builtins.str = ...,
        root: builtins.str = ...,
        time_to_idle: builtins.str = ...,
        time_to_live: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `moka` service.

        Parameters
        ----------
        max_capacity : builtins.int, optional
            Sets the max capacity of the cache.
            Refer to
            [`moka::future::CacheBuilder::max_capacity`](https://docs.rs/moka/latest/moka/future/struct.CacheBuilder.html#method.max_capacity)
        name : builtins.str, optional
            Name for this cache instance.
        root : builtins.str, optional
            root path of this backend
        time_to_idle : builtins.str, optional
            Sets the time to idle of the cache.
            Refer to
            [`moka::future::CacheBuilder::time_to_idle`](https://docs.rs/moka/latest/moka/future/struct.CacheBuilder.html#method.time_to_idle)
        time_to_live : builtins.str, optional
            Sets the time to live of the cache.
            Refer to
            [`moka::future::CacheBuilder::time_to_live`](https://docs.rs/moka/latest/moka/future/struct.CacheBuilder.html#method.time_to_live)

        Returns
        -------
        Operator
            The new `Operator` for `moka` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Mongodb | typing.Literal["mongodb"],
        /,
        *,
        collection: builtins.str = ...,
        connection_string: builtins.str = ...,
        database: builtins.str = ...,
        key_field: builtins.str = ...,
        root: builtins.str = ...,
        value_field: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `mongodb` service.

        Parameters
        ----------
        collection : builtins.str, optional
            collection of this backend
        connection_string : builtins.str, optional
            connection string of this backend
        database : builtins.str, optional
            database of this backend
        key_field : builtins.str, optional
            key field of this backend
        root : builtins.str, optional
            root of this backend
        value_field : builtins.str, optional
            value field of this backend

        Returns
        -------
        Operator
            The new `Operator` for `mongodb` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Mysql | typing.Literal["mysql"],
        /,
        *,
        connection_string: builtins.str = ...,
        key_field: builtins.str = ...,
        root: builtins.str = ...,
        table: builtins.str = ...,
        value_field: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `mysql` service.

        Parameters
        ----------
        connection_string : builtins.str, optional
            This connection string is used to connect to the
            mysql service.
            There are url based formats.
            The format of connect string resembles the url
            format of the mysql client.
            The format is:
            `[scheme://][user[:[password]]@]host[:port][/schema][?attribute1=value1&attribute2=value2...`
            - `mysql://user@localhost` -
            `mysql://user:password@localhost` -
            `mysql://user:password@localhost:3306` -
            `mysql://user:password@localhost:3306/db` For more
            information, please refer to
            <https://docs.rs/sqlx/latest/sqlx/mysql/struct.MySqlConnectOptions.html>.
        key_field : builtins.str, optional
            The key field name for mysql.
        root : builtins.str, optional
            The root for mysql.
        table : builtins.str, optional
            The table name for mysql.
        value_field : builtins.str, optional
            The value field name for mysql.

        Returns
        -------
        Operator
            The new `Operator` for `mysql` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Obs | typing.Literal["obs"],
        /,
        *,
        access_key_id: builtins.str = ...,
        bucket: builtins.str = ...,
        enable_versioning: builtins.bool = ...,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
        secret_access_key: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `obs` service.

        Parameters
        ----------
        access_key_id : builtins.str, optional
            Access key id for obs.
        bucket : builtins.str, optional
            Bucket for obs.
        enable_versioning : builtins.bool, optional
            Is bucket versioning enabled for this bucket
        endpoint : builtins.str, optional
            Endpoint for obs.
        root : builtins.str, optional
            Root for obs.
        secret_access_key : builtins.str, optional
            Secret access key for obs.

        Returns
        -------
        Operator
            The new `Operator` for `obs` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Onedrive | typing.Literal["onedrive"],
        /,
        *,
        access_token: builtins.str = ...,
        client_id: builtins.str = ...,
        client_secret: builtins.str = ...,
        enable_versioning: builtins.bool = ...,
        refresh_token: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `onedrive` service.

        Parameters
        ----------
        access_token : builtins.str, optional
            Microsoft Graph API (also OneDrive API) access token
        client_id : builtins.str, optional
            Microsoft Graph API Application (client) ID that is
            in the Azure's app registration portal
        client_secret : builtins.str, optional
            Microsoft Graph API Application client secret that
            is in the Azure's app registration portal
        enable_versioning : builtins.bool, optional
            Enabling version support
        refresh_token : builtins.str, optional
            Microsoft Graph API (also OneDrive API) refresh
            token
        root : builtins.str, optional
            The root path for the OneDrive service for the file
            access

        Returns
        -------
        Operator
            The new `Operator` for `onedrive` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Oss | typing.Literal["oss"],
        /,
        *,
        access_key_id: builtins.str = ...,
        access_key_secret: builtins.str = ...,
        addressing_style: builtins.str = ...,
        allow_anonymous: builtins.bool = ...,
        batch_max_operations: builtins.int = ...,
        bucket: builtins.str,
        delete_max_size: builtins.int = ...,
        enable_versioning: builtins.bool = ...,
        endpoint: builtins.str = ...,
        oidc_provider_arn: builtins.str = ...,
        oidc_token_file: builtins.str = ...,
        presign_addressing_style: builtins.str = ...,
        presign_endpoint: builtins.str = ...,
        role_arn: builtins.str = ...,
        role_session_name: builtins.str = ...,
        root: builtins.str = ...,
        security_token: builtins.str = ...,
        server_side_encryption: builtins.str = ...,
        server_side_encryption_key_id: builtins.str = ...,
        sts_endpoint: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `oss` service.

        Parameters
        ----------
        access_key_id : builtins.str, optional
            Access key id for oss.
            - this field if it's `is_some` - env value:
            [`ALIBABA_CLOUD_ACCESS_KEY_ID`]
        access_key_secret : builtins.str, optional
            Access key secret for oss.
            - this field if it's `is_some` - env value:
            [`ALIBABA_CLOUD_ACCESS_KEY_SECRET`]
        addressing_style : builtins.str, optional
            Addressing style for oss.
        allow_anonymous : builtins.bool, optional
            Allow anonymous for oss.
        batch_max_operations : builtins.int, optional
            The size of max batch operations.
        bucket : builtins.str
            Bucket for oss.
        delete_max_size : builtins.int, optional
            The size of max delete operations.
        enable_versioning : builtins.bool, optional
            is bucket versioning enabled for this bucket
        endpoint : builtins.str, optional
            Endpoint for oss.
        oidc_provider_arn : builtins.str, optional
            `oidc_provider_arn` will be loaded from - this field
            if it's `is_some` - env value:
            [`ALIBABA_CLOUD_OIDC_PROVIDER_ARN`]
        oidc_token_file : builtins.str, optional
            `oidc_token_file` will be loaded from - this field
            if it's `is_some` - env value:
            [`ALIBABA_CLOUD_OIDC_TOKEN_FILE`]
        presign_addressing_style : builtins.str, optional
            Pre sign addressing style for oss.
        presign_endpoint : builtins.str, optional
            Presign endpoint for oss.
        role_arn : builtins.str, optional
            If `role_arn` is set, we will use already known
            config as source credential to assume role with
            `role_arn`.
            - this field if it's `is_some` - env value:
            [`ALIBABA_CLOUD_ROLE_ARN`]
        role_session_name : builtins.str, optional
            role_session_name for this backend.
        root : builtins.str, optional
            Root for oss.
        security_token : builtins.str, optional
            `security_token` will be loaded from - this field if
            it's `is_some` - env value:
            [`ALIBABA_CLOUD_SECURITY_TOKEN`]
        server_side_encryption : builtins.str, optional
            Server side encryption for oss.
        server_side_encryption_key_id : builtins.str, optional
            Server side encryption key id for oss.
        sts_endpoint : builtins.str, optional
            `sts_endpoint` will be loaded from - this field if
            it's `is_some` - env value:
            [`ALIBABA_CLOUD_STS_ENDPOINT`]

        Returns
        -------
        Operator
            The new `Operator` for `oss` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Persy | typing.Literal["persy"],
        /,
        *,
        datafile: builtins.str = ...,
        index: builtins.str = ...,
        segment: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `persy` service.

        Parameters
        ----------
        datafile : builtins.str, optional
            That path to the persy data file.
            The directory in the path must already exist.
        index : builtins.str, optional
            That name of the persy index.
        segment : builtins.str, optional
            That name of the persy segment.

        Returns
        -------
        Operator
            The new `Operator` for `persy` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Postgresql | typing.Literal["postgresql"],
        /,
        *,
        connection_string: builtins.str = ...,
        key_field: builtins.str = ...,
        root: builtins.str = ...,
        table: builtins.str = ...,
        value_field: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `postgresql` service.

        Parameters
        ----------
        connection_string : builtins.str, optional
            The URL should be with a scheme of either
            `postgres://` or `postgresql://`.
            - `postgresql://user@localhost` -
            `postgresql://user:password@%2Fvar%2Flib%2Fpostgresql/mydb?connect_timeout=10`
            -
            `postgresql://user@host1:1234,host2,host3:5678?target_session_attrs=read-write`
            -
            `postgresql:///mydb?user=user&host=/var/lib/postgresql`
            For more information, please visit
            <https://docs.rs/sqlx/latest/sqlx/postgres/struct.PgConnectOptions.html>.
        key_field : builtins.str, optional
            the key field of postgresql
        root : builtins.str, optional
            Root of this backend.
            All operations will happen under this root.
            Default to `/` if not set.
        table : builtins.str, optional
            the table of postgresql
        value_field : builtins.str, optional
            the value field of postgresql

        Returns
        -------
        Operator
            The new `Operator` for `postgresql` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Redb | typing.Literal["redb"],
        /,
        *,
        datadir: builtins.str = ...,
        root: builtins.str = ...,
        table: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `redb` service.

        Parameters
        ----------
        datadir : builtins.str, optional
            path to the redb data directory.
        root : builtins.str, optional
            The root for redb.
        table : builtins.str, optional
            The table name for redb.

        Returns
        -------
        Operator
            The new `Operator` for `redb` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Redis | typing.Literal["redis"],
        /,
        *,
        cluster_endpoints: builtins.str = ...,
        connection_pool_max_size: builtins.int = ...,
        db: builtins.int,
        default_ttl: typing.Any = ...,
        endpoint: builtins.str = ...,
        password: builtins.str = ...,
        root: builtins.str = ...,
        username: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `redis` service.

        Parameters
        ----------
        cluster_endpoints : builtins.str, optional
            network address of the Redis cluster service.
            Can be
            "tcp://127.0.0.1:6379,tcp://127.0.0.1:6380,tcp://127.0.0.1:6381",
            e.g.
            default is None
        connection_pool_max_size : builtins.int, optional
            The maximum number of connections allowed.
            default is 10
        db : builtins.int
            the number of DBs redis can take is unlimited
            default is db 0
        default_ttl : typing.Any, optional
            The default ttl for put operations..
            a human readable duration string see
            https://docs.rs/humantime/latest/humantime/fn.parse_duration.html
            for more details
        endpoint : builtins.str, optional
            network address of the Redis service.
            Can be "tcp://127.0.0.1:6379", e.g.
            default is "tcp://127.0.0.1:6379"
        password : builtins.str, optional
            the password for authentication default is None
        root : builtins.str, optional
            the working directory of the Redis service.
            Can be "/path/to/dir" default is "/"
        username : builtins.str, optional
            the username to connect redis service.
            default is None

        Returns
        -------
        Operator
            The new `Operator` for `redis` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.S3 | typing.Literal["s3"],
        /,
        *,
        access_key_id: builtins.str = ...,
        allow_anonymous: builtins.bool = ...,
        batch_max_operations: builtins.int = ...,
        bucket: builtins.str,
        checksum_algorithm: builtins.str = ...,
        default_storage_class: builtins.str = ...,
        delete_max_size: builtins.int = ...,
        disable_config_load: builtins.bool = ...,
        disable_ec2_metadata: builtins.bool = ...,
        disable_list_objects_v2: builtins.bool = ...,
        disable_stat_with_override: builtins.bool = ...,
        disable_write_with_if_match: builtins.bool = ...,
        enable_request_payer: builtins.bool = ...,
        enable_versioning: builtins.bool = ...,
        enable_virtual_host_style: builtins.bool = ...,
        enable_write_with_append: builtins.bool = ...,
        endpoint: builtins.str = ...,
        external_id: builtins.str = ...,
        region: builtins.str = ...,
        role_arn: builtins.str = ...,
        role_session_name: builtins.str = ...,
        root: builtins.str = ...,
        secret_access_key: builtins.str = ...,
        server_side_encryption: builtins.str = ...,
        server_side_encryption_aws_kms_key_id: builtins.str = ...,
        server_side_encryption_customer_algorithm: builtins.str = ...,
        server_side_encryption_customer_key: builtins.str = ...,
        server_side_encryption_customer_key_md5: builtins.str = ...,
        session_token: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `s3` service.

        Parameters
        ----------
        access_key_id : builtins.str, optional
            access_key_id of this backend.
            - If access_key_id is set, we will take user's input
            first.
            - If not, we will try to load it from environment.
        allow_anonymous : builtins.bool, optional
            Allow anonymous will allow opendal to send request
            without signing when credential is not loaded.
        batch_max_operations : builtins.int, optional
            Set maximum batch operations of this backend.
            Some compatible services have a limit on the number
            of operations in a batch request.
            For example, R2 could return `Internal Error` while
            batch delete 1000 files.
            Please tune this value based on services' document.
        bucket : builtins.str
            bucket name of this backend.
            required.
        checksum_algorithm : builtins.str, optional
            Checksum Algorithm to use when sending checksums in
            HTTP headers.
            This is necessary when writing to AWS S3 Buckets
            with Object Lock enabled for example.
            Available options: - "crc32c"
        default_storage_class : builtins.str, optional
            default storage_class for this backend.
            Available values: - `DEEP_ARCHIVE` - `GLACIER` -
            `GLACIER_IR` - `INTELLIGENT_TIERING` - `ONEZONE_IA`
            - `EXPRESS_ONEZONE` - `OUTPOSTS` -
            `REDUCED_REDUNDANCY` - `STANDARD` - `STANDARD_IA` S3
            compatible services don't support all of them
        delete_max_size : builtins.int, optional
            Set the maximum delete size of this backend.
            Some compatible services have a limit on the number
            of operations in a batch request.
            For example, R2 could return `Internal Error` while
            batch delete 1000 files.
            Please tune this value based on services' document.
        disable_config_load : builtins.bool, optional
            Disable config load so that opendal will not load
            config from environment.
            For examples: - envs like `AWS_ACCESS_KEY_ID` -
            files like `~/.aws/config`
        disable_ec2_metadata : builtins.bool, optional
            Disable load credential from ec2 metadata.
            This option is used to disable the default behavior
            of opendal to load credential from ec2 metadata,
            a.k.a, IMDSv2
        disable_list_objects_v2 : builtins.bool, optional
            OpenDAL uses List Objects V2 by default to list
            objects.
            However, some legacy services do not yet support V2.
            This option allows users to switch back to the older
            List Objects V1.
        disable_stat_with_override : builtins.bool, optional
            Disable stat with override so that opendal will not
            send stat request with override queries.
            For example, R2 doesn't support stat with
            `response_content_type` query.
        disable_write_with_if_match : builtins.bool, optional
            Disable write with if match so that opendal will not
            send write request with if match headers.
            For example, Ceph RADOS S3 doesn't support write
            with if match.
        enable_request_payer : builtins.bool, optional
            Indicates whether the client agrees to pay for the
            requests made to the S3 bucket.
        enable_versioning : builtins.bool, optional
            is bucket versioning enabled for this bucket
        enable_virtual_host_style : builtins.bool, optional
            Enable virtual host style so that opendal will send
            API requests in virtual host style instead of path
            style.
            - By default, opendal will send API to
            `https://s3.us-east-1.amazonaws.com/bucket_name` -
            Enabled, opendal will send API to
            `https://bucket_name.s3.us-east-1.amazonaws.com`
        enable_write_with_append : builtins.bool, optional
            Enable write with append so that opendal will send
            write request with append headers.
        endpoint : builtins.str, optional
            endpoint of this backend.
            Endpoint must be full uri, e.g.
            - AWS S3: `https://s3.amazonaws.com` or
            `https://s3.{region}.amazonaws.com` - Cloudflare R2:
            `https://<ACCOUNT_ID>.r2.cloudflarestorage.com` -
            Aliyun OSS: `https://{region}.aliyuncs.com` -
            Tencent COS: `https://cos.{region}.myqcloud.com` -
            Minio: `http://127.0.0.1:9000` If user inputs
            endpoint without scheme like "s3.amazonaws.com", we
            will prepend "https://" before it.
            - If endpoint is set, we will take user's input
            first.
            - If not, we will try to load it from environment.
            - If still not set, default to
            `https://s3.amazonaws.com`.
        external_id : builtins.str, optional
            external_id for this backend.
        region : builtins.str, optional
            Region represent the signing region of this
            endpoint.
            This is required if you are using the default AWS S3
            endpoint.
            If using a custom endpoint, - If region is set, we
            will take user's input first.
            - If not, we will try to load it from environment.
        role_arn : builtins.str, optional
            role_arn for this backend.
            If `role_arn` is set, we will use already known
            config as source credential to assume role with
            `role_arn`.
        role_session_name : builtins.str, optional
            role_session_name for this backend.
        root : builtins.str, optional
            root of this backend.
            All operations will happen under this root.
            default to `/` if not set.
        secret_access_key : builtins.str, optional
            secret_access_key of this backend.
            - If secret_access_key is set, we will take user's
            input first.
            - If not, we will try to load it from environment.
        server_side_encryption : builtins.str, optional
            server_side_encryption for this backend.
            Available values: `AES256`, `aws:kms`.
        server_side_encryption_aws_kms_key_id : builtins.str, optional
            server_side_encryption_aws_kms_key_id for this
            backend - If `server_side_encryption` set to
            `aws:kms`, and
            `server_side_encryption_aws_kms_key_id` is not set,
            S3 will use aws managed kms key to encrypt data.
            - If `server_side_encryption` set to `aws:kms`, and
            `server_side_encryption_aws_kms_key_id` is a valid
            kms key id, S3 will use the provided kms key to
            encrypt data.
            - If the `server_side_encryption_aws_kms_key_id` is
            invalid or not found, an error will be returned.
            - If `server_side_encryption` is not `aws:kms`,
            setting `server_side_encryption_aws_kms_key_id` is a
            noop.
        server_side_encryption_customer_algorithm : builtins.str, optional
            server_side_encryption_customer_algorithm for this
            backend.
            Available values: `AES256`.
        server_side_encryption_customer_key : builtins.str, optional
            server_side_encryption_customer_key for this
            backend.
            Value: BASE64-encoded key that matches algorithm
            specified in
            `server_side_encryption_customer_algorithm`.
        server_side_encryption_customer_key_md5 : builtins.str, optional
            Set server_side_encryption_customer_key_md5 for this
            backend.
            Value: MD5 digest of key specified in
            `server_side_encryption_customer_key`.
        session_token : builtins.str, optional
            session_token (aka, security token) of this backend.
            This token will expire after sometime, it's
            recommended to set session_token by hand.

        Returns
        -------
        Operator
            The new `Operator` for `s3` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Seafile | typing.Literal["seafile"],
        /,
        *,
        endpoint: builtins.str = ...,
        password: builtins.str = ...,
        repo_name: builtins.str,
        root: builtins.str = ...,
        username: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `seafile` service.

        Parameters
        ----------
        endpoint : builtins.str, optional
            endpoint address of this backend.
        password : builtins.str, optional
            password of this backend.
        repo_name : builtins.str
            repo_name of this backend.
            required.
        root : builtins.str, optional
            root of this backend.
            All operations will happen under this root.
        username : builtins.str, optional
            username of this backend.

        Returns
        -------
        Operator
            The new `Operator` for `seafile` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Sftp | typing.Literal["sftp"],
        /,
        *,
        enable_copy: builtins.bool = ...,
        endpoint: builtins.str = ...,
        key: builtins.str = ...,
        known_hosts_strategy: builtins.str = ...,
        root: builtins.str = ...,
        user: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `sftp` service.

        Parameters
        ----------
        enable_copy : builtins.bool, optional
            enable_copy of this backend
        endpoint : builtins.str, optional
            endpoint of this backend
        key : builtins.str, optional
            key of this backend
        known_hosts_strategy : builtins.str, optional
            known_hosts_strategy of this backend
        root : builtins.str, optional
            root of this backend
        user : builtins.str, optional
            user of this backend

        Returns
        -------
        Operator
            The new `Operator` for `sftp` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Sled | typing.Literal["sled"],
        /,
        *,
        datadir: builtins.str = ...,
        root: builtins.str = ...,
        tree: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `sled` service.

        Parameters
        ----------
        datadir : builtins.str, optional
            That path to the sled data directory.
        root : builtins.str, optional
            The root for sled.
        tree : builtins.str, optional
            The tree for sled.

        Returns
        -------
        Operator
            The new `Operator` for `sled` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Sqlite | typing.Literal["sqlite"],
        /,
        *,
        connection_string: builtins.str = ...,
        key_field: builtins.str = ...,
        root: builtins.str = ...,
        table: builtins.str = ...,
        value_field: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `sqlite` service.

        Parameters
        ----------
        connection_string : builtins.str, optional
            Set the connection_string of the sqlite service.
            This connection string is used to connect to the
            sqlite service.
            The format of connect string resembles the url
            format of the sqlite client: - `sqlite::memory:` -
            `sqlite:data.db` - `sqlite://data.db` For more
            information, please visit
            <https://docs.rs/sqlx/latest/sqlx/sqlite/struct.SqliteConnectOptions.html>.
        key_field : builtins.str, optional
            Set the key field name of the sqlite service to
            read/write.
            Default to `key` if not specified.
        root : builtins.str, optional
            set the working directory, all operations will be
            performed under it.
            default: "/"
        table : builtins.str, optional
            Set the table name of the sqlite service to
            read/write.
        value_field : builtins.str, optional
            Set the value field name of the sqlite service to
            read/write.
            Default to `value` if not specified.

        Returns
        -------
        Operator
            The new `Operator` for `sqlite` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Swift | typing.Literal["swift"],
        /,
        *,
        container: builtins.str = ...,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
        token: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `swift` service.

        Parameters
        ----------
        container : builtins.str, optional
            The container for Swift.
        endpoint : builtins.str, optional
            The endpoint for Swift.
        root : builtins.str, optional
            The root for Swift.
        token : builtins.str, optional
            The token for Swift.

        Returns
        -------
        Operator
            The new `Operator` for `swift` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Upyun | typing.Literal["upyun"],
        /,
        *,
        bucket: builtins.str,
        operator: builtins.str = ...,
        password: builtins.str = ...,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `upyun` service.

        Parameters
        ----------
        bucket : builtins.str
            bucket address of this backend.
        operator : builtins.str, optional
            username of this backend.
        password : builtins.str, optional
            password of this backend.
        root : builtins.str, optional
            root of this backend.
            All operations will happen under this root.

        Returns
        -------
        Operator
            The new `Operator` for `upyun` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.VercelArtifacts
        | typing.Literal["vercel-artifacts"],
        /,
        *,
        access_token: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `vercel-artifacts` service.

        Parameters
        ----------
        access_token : builtins.str, optional
            The access token for Vercel.

        Returns
        -------
        Operator
            The new `Operator` for `vercel-artifacts` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Webdav | typing.Literal["webdav"],
        /,
        *,
        disable_copy: builtins.bool = ...,
        endpoint: builtins.str = ...,
        password: builtins.str = ...,
        root: builtins.str = ...,
        token: builtins.str = ...,
        username: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `webdav` service.

        Parameters
        ----------
        disable_copy : builtins.bool, optional
            WebDAV Service doesn't support copy.
        endpoint : builtins.str, optional
            endpoint of this backend
        password : builtins.str, optional
            password of this backend
        root : builtins.str, optional
            root of this backend
        token : builtins.str, optional
            token of this backend
        username : builtins.str, optional
            username of this backend

        Returns
        -------
        Operator
            The new `Operator` for `webdav` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.Webhdfs | typing.Literal["webhdfs"],
        /,
        *,
        atomic_write_dir: builtins.str = ...,
        delegation: builtins.str = ...,
        disable_list_batch: builtins.bool = ...,
        endpoint: builtins.str = ...,
        root: builtins.str = ...,
        user_name: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `webhdfs` service.

        Parameters
        ----------
        atomic_write_dir : builtins.str, optional
            atomic_write_dir of this backend
        delegation : builtins.str, optional
            Delegation token for webhdfs.
        disable_list_batch : builtins.bool, optional
            Disable batch listing
        endpoint : builtins.str, optional
            Endpoint for webhdfs.
        root : builtins.str, optional
            Root for webhdfs.
        user_name : builtins.str, optional
            Name of the user for webhdfs.

        Returns
        -------
        Operator
            The new `Operator` for `webhdfs` service
        """
    @typing.overload
    def __new__(
        cls,
        scheme: opendal.services.Scheme.YandexDisk | typing.Literal["yandex-disk"],
        /,
        *,
        access_token: builtins.str,
        root: builtins.str = ...,
    ) -> typing_extensions.Self:
        r"""
        Create a new `Operator` for `yandex-disk` service.

        Parameters
        ----------
        access_token : builtins.str
            yandex disk oauth access_token.
        root : builtins.str, optional
            root of this backend.
            All operations will happen under this root.

        Returns
        -------
        Operator
            The new `Operator` for `yandex-disk` service
        """
