/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public final class DynamicConfigAddCardinalityEstimatorConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1770240;
    public static final int RESPONSE_MESSAGE_TYPE = 1770241;
    private static final int REQUEST_BACKUP_COUNT_FIELD_OFFSET = 16;
    private static final int REQUEST_ASYNC_BACKUP_COUNT_FIELD_OFFSET = 20;
    private static final int REQUEST_MERGE_BATCH_SIZE_FIELD_OFFSET = 24;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 28;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private DynamicConfigAddCardinalityEstimatorConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, int backupCount, int asyncBackupCount, @Nullable String splitBrainProtectionName, String mergePolicy, int mergeBatchSize) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("DynamicConfig.AddCardinalityEstimatorConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[28], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1770240);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, backupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, asyncBackupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, mergeBatchSize);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        CodecUtil.encodeNullable(clientMessage, splitBrainProtectionName, StringCodec::encode);
        StringCodec.encode(clientMessage, mergePolicy);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.backupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.asyncBackupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        request.mergeBatchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        request.name = StringCodec.decode(iterator);
        request.splitBrainProtectionName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.mergePolicy = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1770241);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public int backupCount;
        public int asyncBackupCount;
        @Nullable
        public String splitBrainProtectionName;
        public String mergePolicy;
        public int mergeBatchSize;
    }
}

