/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

public class CircularListCursor<E> {
    private int index;
    private final E[] elementData;
    private int size;

    public CircularListCursor(E[] elementData) {
        this.elementData = elementData;
        this.size = elementData.length;
    }

    public boolean advance() {
        if (this.size == 0) {
            return false;
        }
        if (++this.index >= this.size) {
            this.index = 0;
        }
        return true;
    }

    public E value() {
        return this.elementData[this.index];
    }

    public void remove() {
        int numMoved = this.size - this.index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, this.index + 1, this.elementData, this.index, numMoved);
        }
        this.elementData[--this.size] = null;
        --this.index;
        if (this.index < 0) {
            this.index = this.size - 1;
        }
    }

    public String toString() {
        return "CircularListCursor{index=" + this.index + "}";
    }

    public E[] getArray() {
        return this.elementData;
    }

    public int getSize() {
        return this.size;
    }
}

