/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j;

import com.github.caldav4j.cache.CalDAVResourceCache;
import com.github.caldav4j.cache.EhCacheResourceCache;
import com.github.caldav4j.cache.NoOpResourceCache;
import com.github.caldav4j.exceptions.CacheException;
import com.github.caldav4j.methods.CalDAV4JMethodFactory;
import com.github.caldav4j.methods.HttpPutMethod;
import com.github.caldav4j.model.request.CalendarRequest;
import com.github.caldav4j.util.UrlUtils;
import java.net.URI;
import net.fortuna.ical4j.model.Calendar;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIUtils;

public abstract class CalDAVCalendarCollectionBase {
    protected CalDAV4JMethodFactory methodFactory = null;
    protected String calendarCollectionRoot = null;
    protected HttpHost httpHost = null;
    protected String prodId = null;
    protected CalDAVResourceCache cache = NoOpResourceCache.getCacheInstance();
    private boolean tolerantParsing = false;

    public HttpHost getDefaultHttpHost(URI path) {
        if (this.httpHost == null) {
            return URIUtils.extractHost((URI)path);
        }
        return this.httpHost;
    }

    public HttpHost getHttpHost() {
        return this.httpHost;
    }

    public void setHttpHost(HttpHost httpHost) {
        this.httpHost = httpHost;
    }

    public CalDAV4JMethodFactory getMethodFactory() {
        return this.methodFactory;
    }

    public void setMethodFactory(CalDAV4JMethodFactory methodFactory) {
        this.methodFactory = methodFactory;
    }

    public boolean isTolerantParsing() {
        return this.tolerantParsing;
    }

    public void setTolerantParsing(boolean tolerantParsing) {
        this.tolerantParsing = tolerantParsing;
    }

    public String getCalendarCollectionRoot() {
        return this.calendarCollectionRoot;
    }

    public void setCalendarCollectionRoot(String path) {
        URI temp = URI.create(path);
        if (temp.isAbsolute()) {
            this.setHttpHost(URIUtils.extractHost((URI)temp));
        }
        this.calendarCollectionRoot = UrlUtils.removeDoubleSlashes(UrlUtils.ensureTrailingSlash(temp.getPath()));
    }

    public CalDAVResourceCache getCache() {
        return this.cache;
    }

    public void setCache(CalDAVResourceCache cache) {
        this.cache = cache;
    }

    public boolean isCacheEnabled() {
        boolean p = this.cache instanceof NoOpResourceCache;
        return !p;
    }

    public String getHref(String path) {
        HttpHost httpHost = this.getDefaultHttpHost(URI.create(this.calendarCollectionRoot));
        int port = httpHost.getPort();
        String scheme = httpHost.getSchemeName();
        String portString = "";
        if (port != 80 && "http".equals(scheme) || port != 443 && "https".equals(scheme)) {
            portString = ":" + port;
        }
        return UrlUtils.removeDoubleSlashes(String.format("%s://%s%s/%s", scheme, httpHost.getHostName(), portString, path));
    }

    HttpPutMethod createPutMethodForNewResource(String resourceName, Calendar calendar) {
        CalendarRequest cr = new CalendarRequest();
        cr.setAllEtags(true);
        cr.setIfNoneMatch(true);
        cr.setCalendar(calendar);
        return this.methodFactory.createPutMethod(this.calendarCollectionRoot + resourceName, cr);
    }

    public void enableSimpleCache() {
        EhCacheResourceCache cache = null;
        if (!this.isCacheEnabled()) {
            try {
                cache = EhCacheResourceCache.createSimpleCache();
            }
            catch (CacheException e) {
                e.printStackTrace();
            }
            this.setCache(cache);
        }
    }

    public void disableSimpleCache() {
        EhCacheResourceCache.removeSimpleCache();
        this.setCache(NoOpResourceCache.getCacheInstance());
    }
}

