/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class StreamPumper
extends Thread {
    private final InputStream stream;
    private final LineConsumer consumer;

    public StreamPumper(@NonNull InputStream stream, @NonNull LineConsumer consumer) {
        Objects.requireNonNull(stream, "stream must not be null");
        Objects.requireNonNull(stream, "consumer must not be null");
        this.stream = stream;
        this.consumer = consumer;
        this.setDaemon(true);
    }

    public @NonNull LineConsumer getConsumer() {
        return this.consumer;
    }

    @Override
    public void run() {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.stream, Charset.defaultCharset()));){
            String line = bufferedReader.readLine();
            while (line != null) {
                this.consumer.consume(line);
                line = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @FunctionalInterface
    public static interface LineConsumer {
        public void consume(@NonNull String var1);
    }
}

