/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client.internal;

import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.kurento.client.TFuture;
import org.kurento.client.TransactionExecutionException;
import org.kurento.client.TransactionRollbackException;
import org.kurento.client.internal.client.operation.Operation;
import org.kurento.client.internal.server.KurentoServerException;
import org.kurento.commons.exception.KurentoException;

public class TFutureImpl<V>
implements TFuture<V> {
    private SettableFuture<V> future = SettableFuture.create();
    private Operation operation;

    public TFutureImpl(Operation operation) {
        this.operation = operation;
    }

    @Override
    public boolean isRollback() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isCommitted() {
        return this.future.isDone();
    }

    @Override
    public V get() {
        try {
            return (V)this.future.get();
        }
        catch (InterruptedException e) {
            throw new KurentoException((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof KurentoServerException) {
                throw new TransactionExecutionException(this.operation, ((KurentoServerException)((Object)e.getCause())).getError());
            }
            throw new KurentoException(e.getCause());
        }
        catch (CancellationException e) {
            throw new TransactionRollbackException();
        }
    }

    public SettableFuture<V> getFuture() {
        return this.future;
    }
}

