/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.util.function.Supplier;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.ozone.om.OmMetadataReaderMetrics;
import org.apache.ratis.util.MemoizedSupplier;

@InterfaceAudience.Private
@Metrics(about="Snapshot Manager Metrics", context="dfs")
public final class OmSnapshotMetrics
implements OmMetadataReaderMetrics {
    private static final String SOURCE_NAME = OmSnapshotMetrics.class.getSimpleName();
    private static final Supplier<OmSnapshotMetrics> SUPPLIER = MemoizedSupplier.valueOf(() -> {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (OmSnapshotMetrics)ms.register(SOURCE_NAME, "Snapshot Manager Metrics", (Object)new OmSnapshotMetrics());
    });
    @Metric
    private MutableCounterLong numKeyLookup;
    @Metric
    private MutableCounterLong numKeyLookupFails;
    @Metric
    private MutableCounterLong numGetKeyInfo;
    @Metric
    private MutableCounterLong numGetKeyInfoFails;
    @Metric
    private MutableCounterLong numListStatus;
    @Metric
    private MutableCounterLong numListStatusFails;
    @Metric
    private MutableCounterLong numGetFileStatus;
    @Metric
    private MutableCounterLong numGetFileStatusFails;
    @Metric
    private MutableCounterLong numLookupFile;
    @Metric
    private MutableCounterLong numLookupFileFails;
    @Metric
    private MutableCounterLong numKeyLists;
    @Metric
    private MutableCounterLong numKeyListFails;
    @Metric
    private MutableCounterLong numGetAcl;
    @Metric
    private MutableCounterLong numKeyOps;
    @Metric
    private MutableCounterLong numFSOps;
    @Metric
    private MutableCounterLong numGetObjectTagging;
    @Metric
    private MutableCounterLong numGetObjectTaggingFails;

    private OmSnapshotMetrics() {
    }

    public static OmSnapshotMetrics getInstance() {
        return SUPPLIER.get();
    }

    @Override
    public void incNumKeyLookups() {
        this.numKeyOps.incr();
        this.numKeyLookup.incr();
    }

    @Override
    public void incNumKeyLookupFails() {
        this.numKeyLookupFails.incr();
    }

    @Override
    public void incNumGetKeyInfo() {
        this.numKeyOps.incr();
        this.numGetKeyInfo.incr();
    }

    @Override
    public void incNumGetKeyInfoFails() {
        this.numGetKeyInfoFails.incr();
    }

    @Override
    public void incNumListStatus() {
        this.numKeyOps.incr();
        this.numFSOps.incr();
        this.numListStatus.incr();
    }

    @Override
    public void incNumListStatusFails() {
        this.numListStatusFails.incr();
    }

    @Override
    public void incNumGetFileStatus() {
        this.numKeyOps.incr();
        this.numFSOps.incr();
        this.numGetFileStatus.incr();
    }

    @Override
    public void incNumGetFileStatusFails() {
        this.numGetFileStatusFails.incr();
    }

    @Override
    public void incNumLookupFile() {
        this.numKeyOps.incr();
        this.numFSOps.incr();
        this.numLookupFile.incr();
    }

    @Override
    public void incNumLookupFileFails() {
        this.numLookupFileFails.incr();
    }

    @Override
    public void incNumKeyLists() {
        this.numKeyLists.incr();
    }

    @Override
    public void incNumKeyListFails() {
        this.numKeyListFails.incr();
    }

    @Override
    public void incNumGetAcl() {
        this.numGetAcl.incr();
    }

    @Override
    public void incNumGetObjectTagging() {
        this.numGetObjectTagging.incr();
        this.numKeyOps.incr();
    }

    @Override
    public void incNumGetObjectTaggingFails() {
        this.numGetObjectTaggingFails.incr();
    }
}

