/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key.acl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyAclRequest;
import org.apache.hadoop.ozone.om.request.util.ObjectParser;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.acl.OMKeyAclResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyRemoveAclRequest
extends OMKeyAclRequest {
    private static final Logger LOG;
    private String path;
    private List<OzoneAcl> ozoneAcls;
    private OzoneObj obj;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMKeyRemoveAclRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMKeyRemoveAclRequest.class);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        long modificationTime = Time.now();
        OzoneManagerProtocolProtos.RemoveAclRequest.Builder removeAclRequestBuilder = this.getOmRequest().getRemoveAclRequest().toBuilder().setModificationTime(modificationTime);
        return this.getOmRequest().toBuilder().setRemoveAclRequest(removeAclRequestBuilder).setUserInfo(this.getUserInfo()).build();
    }

    public OMKeyRemoveAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest, OzoneManager ozoneManager) {
        super(omRequest);
        OzoneManagerProtocolProtos.RemoveAclRequest removeAclRequest = this.getOmRequest().getRemoveAclRequest();
        this.obj = OzoneObjInfo.fromProtobuf((OzoneManagerProtocolProtos.OzoneObj)removeAclRequest.getObj());
        this.path = this.obj.getPath();
        this.ozoneAcls = Lists.newArrayList((Object[])new OzoneAcl[]{OzoneAcl.fromProtobuf((OzoneManagerProtocolProtos.OzoneAclInfo)removeAclRequest.getAcl())});
        this.initializeBucketLayout(ozoneManager);
    }

    @Override
    String getPath() {
        return this.path;
    }

    @Override
    OzoneObj getObject() {
        return this.obj;
    }

    @Override
    OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
    }

    @Override
    OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmKeyInfo omKeyInfo, boolean operationResult) {
        omResponse.setSuccess(operationResult);
        omResponse.setRemoveAclResponse(OzoneManagerProtocolProtos.RemoveAclResponse.newBuilder().setResponse(operationResult));
        return new OMKeyAclResponse(omResponse.build(), omKeyInfo);
    }

    @Override
    void onComplete(OMClientRequest.Result result, boolean operationResult, Exception exception, long trxnLogIndex, AuditLogger auditLogger, Map<String, String> auditMap) {
        switch (result) {
            case SUCCESS: {
                if (!LOG.isDebugEnabled()) break;
                if (operationResult) {
                    LOG.debug("Remove acl: {} to path: {} success!", this.ozoneAcls, (Object)this.path);
                    break;
                }
                LOG.debug("Acl {} not removed from path {} as it does not exist", this.ozoneAcls, (Object)this.path);
                break;
            }
            case FAILURE: {
                LOG.error("Remove acl {} to path {} failed!", new Object[]{this.ozoneAcls, this.path, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeyRemoveAclRequest: {}", (Object)this.getOmRequest());
            }
        }
        if (this.ozoneAcls != null) {
            auditMap.put("acl", this.ozoneAcls.toString());
        }
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.REMOVE_ACL, auditMap, exception, this.getOmRequest().getUserInfo()));
    }

    @Override
    boolean apply(OmKeyInfo omKeyInfo, long trxnLogIndex) {
        return omKeyInfo.removeAcl(this.ozoneAcls.get(0));
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        ozoneManager.getMetrics().incNumRemoveAcl();
        return super.validateAndUpdateCache(ozoneManager, context);
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.RemoveAcl)
    public static OzoneManagerProtocolProtos.OMRequest blockRemoveAclWithBucketLayoutFromOldClient(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws IOException {
        if (req.getRemoveAclRequest().hasObj()) {
            OzoneObjInfo obj = OzoneObjInfo.fromProtobuf((OzoneManagerProtocolProtos.OzoneObj)req.getRemoveAclRequest().getObj());
            String path = obj.getPath();
            ObjectParser objectParser = new ObjectParser(path, OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY);
            String volume = objectParser.getVolume();
            String bucket = objectParser.getBucket();
            BucketLayout bucketLayout = ctx.getBucketLayout(volume, bucket);
            bucketLayout.validateSupportedOperation();
        }
        return req;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMKeyRemoveAclRequest.java", OMKeyRemoveAclRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.key.acl.OMKeyRemoveAclRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 65);
    }
}

